# Granite Warehouse App (PHP + MySQL + jQuery + Bootstrap)

## Setup
- Create database and tables:
  - Import `database/schema.sql` into MySQL.
- Configure DB in `config.php` (DB_HOST, DB_USER, DB_PASS, DB_NAME, BASE_PATH).
- In Apache/XAMPP, visit: `http://localhost/new_sw/login.php` (or your configured base).

## Initial admin user
- Insert a super admin manually in MySQL:
```
INSERT INTO users (username, full_name, role, is_active, password_hash)
VALUES ('superadmin', 'Super Admin', 'super_admin', 1, '$2y$10$replaceWithYourHash');
```
- Generate hash in PHP using:
```
<?php echo password_hash('YourPassword', PASSWORD_DEFAULT); ?>
```

## Modules
- Users: list/add/edit/delete with Bootstrap modals and AJAX (`pages/users.php`, `api/users.php`).
- Suppliers: list/add/edit/delete with Bootstrap modals and AJAX (`pages/suppliers.php`, `api/suppliers.php`).
- Purchase Orders: list/add/edit/delete with Bootstrap modals and AJAX (`pages/purchase_orders.php`, `api/purchase_orders.php`).

## Security
- CSRF tokens on mutating requests.
- Role-based access: only `admin` and `super_admin` can mutate data.
- Passwords stored using `password_hash`.
