<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_login();
header('Content-Type: application/json');
$mysqli = db();
$action = $_GET['action'] ?? 'kpis';

function ymd($s){ return preg_match('/^\d{4}-\d{2}-\d{2}$/',$s) ? $s : null; }

function branch_where(&$types, &$params){
  $w = [];
  if (!has_role(['admin','super_admin'])){
    $bid = (int)(sess_branch_id() ?? 0);
    if ($bid>0){ $w[] = 'i.branch_id=?'; $types.='i'; $params[]=$bid; }
  } else if (!empty($_GET['branch_id'])){
    $w[]='i.branch_id=?'; $types.='i'; $params[]=(int)$_GET['branch_id'];
  }
  return $w;
}

switch ($action) {
  case 'kpis': {
    $today = date('Y-m-d');
    $monthStart = date('Y-m-01');

    // Revenue today, month; outstanding balance; invoice count
    $types=''; $params=[]; $w = branch_where($types,$params);

    // Today revenue
    $sqlT = "SELECT COALESCE(SUM(grand_total),0) v FROM invoices i WHERE i.status IN ('issued','paid') AND i.invoice_date=?";
    $typesT='s'.$types; $paramsT=array_merge([$today],$params);
    if ($w) $sqlT .= ' AND '.implode(' AND ',$w);
    $st=$mysqli->prepare($sqlT); $st->bind_param($typesT, ...$paramsT); $st->execute(); $revToday=(float)($st->get_result()->fetch_row()[0]??0);

    // Month revenue
    $sqlM = "SELECT COALESCE(SUM(grand_total),0) v FROM invoices i WHERE i.status IN ('issued','paid') AND i.invoice_date BETWEEN ? AND ?";
    $typesM='ss'.$types; $paramsM=array_merge([$monthStart,$today],$params);
    if ($w) $sqlM .= ' AND '.implode(' AND ',$w);
    $sm=$mysqli->prepare($sqlM); $sm->bind_param($typesM, ...$paramsM); $sm->execute(); $revMonth=(float)($sm->get_result()->fetch_row()[0]??0);

    // Outstanding
    $typesO=$types; $paramsO=$params;
    $dueDaysExpr = "CASE WHEN i.payment_term='Credit' THEN 30 ELSE 0 END";
    $dueDateExpr = "DATE_ADD(i.invoice_date, INTERVAL $dueDaysExpr DAY)";
    $sqlO = "SELECT SUM(GREATEST(i.grand_total-COALESCE(p.paid,0),0)) bal
             FROM invoices i LEFT JOIN (SELECT invoice_id, SUM(amount) paid FROM payments GROUP BY invoice_id) p ON p.invoice_id=i.id
             WHERE i.status IN ('issued','paid')";
    if ($w) $sqlO .= ' AND '.implode(' AND ',$w);
    $so=$mysqli->prepare($sqlO); if($typesO){ $so->bind_param($typesO, ...$paramsO);} $so->execute(); $outBal=(float)($so->get_result()->fetch_row()[0]??0);

    // Customers count (all active)
    $cust = $mysqli->query("SELECT COUNT(*) FROM customers")->fetch_row()[0] ?? 0;

    json_response(['data'=>[
      'revenue_today'=>$revToday,
      'revenue_month'=>$revMonth,
      'outstanding'=>$outBal,
      'customers'=>(int)$cust,
    ]]);
    break; }

  case 'sales_trend': {
    // Last 6 months revenue
    $types=''; $params=[]; $w = branch_where($types,$params);
    $sql = "SELECT DATE_FORMAT(i.invoice_date,'%Y-%m') ym, COALESCE(SUM(i.grand_total),0) total
            FROM invoices i
            WHERE i.status IN ('issued','paid')
            GROUP BY ym ORDER BY ym DESC LIMIT 6";
    if ($w){
      $sql = "SELECT DATE_FORMAT(i.invoice_date,'%Y-%m') ym, COALESCE(SUM(i.grand_total),0) total FROM invoices i WHERE i.status IN ('issued','paid') AND ".implode(' AND ',$w)." GROUP BY ym ORDER BY ym DESC LIMIT 6";
    }
    $st=$mysqli->prepare($sql); if($types){ $st->bind_param($types, ...$params);} $st->execute();
    $rows=[]; $res=$st->get_result(); while($r=$res->fetch_assoc()) $rows[]=$r; $rows=array_reverse($rows);
    json_response(['data'=>$rows]); break; }

  case 'top_finishes': {
    $types=''; $params=[]; $w = branch_where($types,$params);
    $sql = "SELECT fp.finish_id name, SUM(ii.line_total) total
            FROM invoice_items ii JOIN invoices i ON i.id=ii.invoice_id LEFT JOIN final_products fp ON fp.id=ii.final_product_id
            WHERE i.status IN ('issued','paid')";
    if ($w) $sql .= ' AND '.implode(' AND ',$w);
    $sql .= ' GROUP BY fp.finish_id ORDER BY total DESC LIMIT 5';
    $st=$mysqli->prepare($sql); if($types){ $st->bind_param($types, ...$params);} $st->execute();
    $rows=[]; $res=$st->get_result(); while($r=$res->fetch_assoc()) $rows[]=$r; json_response(['data'=>$rows]); break; }

  case 'outstanding_age': {
    $types=''; $params=[]; $w = branch_where($types,$params);
    $sql = "SELECT 
              SUM(CASE WHEN DATEDIFF(CURDATE(), x.invoice_date) <= 7 THEN bal ELSE 0 END) AS d0_7,
              SUM(CASE WHEN DATEDIFF(CURDATE(), x.invoice_date) BETWEEN 8 AND 30 THEN bal ELSE 0 END) AS d8_30,
              SUM(CASE WHEN DATEDIFF(CURDATE(), x.invoice_date) BETWEEN 31 AND 60 THEN bal ELSE 0 END) AS d31_60,
              SUM(CASE WHEN DATEDIFF(CURDATE(), x.invoice_date) > 60 THEN bal ELSE 0 END) AS d60p
            FROM (
              SELECT i.*, GREATEST(i.grand_total-COALESCE(p.paid,0),0) bal
              FROM invoices i LEFT JOIN (SELECT invoice_id, SUM(amount) paid FROM payments GROUP BY invoice_id) p ON p.invoice_id=i.id
              WHERE i.status IN ('issued','paid')";
    if ($w) { $sql .= ' AND '.implode(' AND ', $w); }
    $sql .= ") x";
    $st=$mysqli->prepare($sql); if($types){ $st->bind_param($types, ...$params);} $st->execute();
    $row=$st->get_result()->fetch_assoc() ?: ['d0_7'=>0,'d8_30'=>0,'d31_60'=>0,'d60p'=>0];
    json_response(['data'=>$row]); break; }

  case 'raw_inventory': {
    // Summary for raw_material_products
    $rows = [
      'total' => 0,
      'received' => 0,
      'in_polishing' => 0,
      'polished' => 0,
      'finished' => 0,
      'value' => 0.0,
      'sq_m2' => 0.0,
      'sq_ft' => 0.0,
    ];
    $res = $mysqli->query("SELECT COUNT(*) total, 
        SUM(status='received') received,
        SUM(status='in_polishing') in_polishing,
        SUM(status='polished') polished,
        SUM(status='finished') finished,
        COALESCE(SUM(value),0) value,
        COALESCE(SUM(sq_m2),0) sq_m2
      FROM raw_material_products");
    if ($res) { $r=$res->fetch_assoc(); if($r){ $rows['total']=(int)$r['total']; $rows['received']=(int)$r['received']; $rows['in_polishing']=(int)$r['in_polishing']; $rows['polished']=(int)$r['polished']; $rows['finished']=(int)$r['finished']; $rows['value']=(float)$r['value']; $rows['sq_m2']=(float)$r['sq_m2']; $rows['sq_ft']=$rows['sq_m2']*10.76391041671; } }
    json_response(['data'=>$rows]); break; }

  case 'final_inventory': {
    // Summary for final_products
    $types=''; $params=[]; $w=[];
    if (!has_role(['admin','super_admin'])){ $bid=(int)(sess_branch_id() ?? 0); if($bid>0){ $w[]='branch_id=?'; $types.='i'; $params[]=$bid; } }
    $sql = 'SELECT COUNT(*) total, SUM(sale_status=\'available\') available, SUM(sale_status=\'reserved\') reserved, SUM(sale_status=\'sold\') sold FROM final_products';
    if ($w) $sql .= ' WHERE '.implode(' AND ', $w);
    $st=$mysqli->prepare($sql); if($types){ $st->bind_param($types, ...$params);} $st->execute();
    $r=$st->get_result()->fetch_assoc() ?: ['total'=>0,'available'=>0,'reserved'=>0,'sold'=>0];
    json_response(['data'=>['total'=>(int)$r['total'],'available'=>(int)$r['available'],'reserved'=>(int)$r['reserved'],'sold'=>(int)$r['sold']]]); break; }

  case 'cut_inventory': {
    // Summary for cut_pieces
    $res = $mysqli->query("SELECT COUNT(*) total, SUM(is_available=1) available, SUM(status='usable') usable, SUM(status='unusable') unusable, COALESCE(SUM(area_sq_ft),0) area_sq_ft FROM cut_pieces");
    $r=$res?$res->fetch_assoc():null; if(!$r){ $r=['total'=>0,'available'=>0,'usable'=>0,'unusable'=>0,'area_sq_ft'=>0]; }
    json_response(['data'=>['total'=>(int)$r['total'],'available'=>(int)$r['available'],'usable'=>(int)$r['usable'],'unusable'=>(int)$r['unusable'],'area_sq_ft'=>(float)$r['area_sq_ft']]]); break; }

  case 'production_inventory': {
    // Summary for production_items (basic counts)
    $res = $mysqli->query("SELECT COUNT(*) total FROM production_items");
    $total = $res ? (int)($res->fetch_row()[0]??0) : 0;
    json_response(['data'=>['total'=>$total]]); break; }

  case 'recent_expenditures': {
    // Current month expenditures (latest 5)
    $first = date('Y-m-01');
    $today = date('Y-m-d');

    $types='ss';
    $params=[$first,$today];
    $w=[];

    // Branch scope
    if (!has_role(['admin','super_admin'])){
      $bid = (int)(sess_branch_id() ?? 0);
      if ($bid>0){ $w[]='e.branch_id=?'; $types.='i'; $params[]=$bid; }
    } else if (!empty($_GET['branch_id'])){
      $w[]='e.branch_id=?'; $types.='i'; $params[]=(int)$_GET['branch_id'];
    }

    $sql = "SELECT e.id,
                   e.expense_date AS exp_date,
                   e.description,
                   e.amount,
                   COALESCE(c.name,'') AS category
            FROM expenditures e
            LEFT JOIN expenditure_categories c ON c.id=e.category_id
            WHERE e.expense_date BETWEEN ? AND ?";
    if ($w) { $sql .= ' AND '.implode(' AND ',$w); }
    $sql .= ' ORDER BY e.expense_date DESC, e.id DESC LIMIT 5';

    $st = $mysqli->prepare($sql);
    if (!$st){ json_response(['message'=>'SQL prepare failed (recent_expenditures list): '.$mysqli->error],500); }
    $st->bind_param($types, ...$params);
    $st->execute();
    $res = $st->get_result();
    $rows=[]; while($r=$res->fetch_assoc()) $rows[]=$r;

    // Month total
    $sqlT = "SELECT COALESCE(SUM(e.amount),0)
             FROM expenditures e
             WHERE e.expense_date BETWEEN ? AND ?";
    if ($w) { $sqlT .= ' AND '.implode(' AND ',$w); }
    $st2 = $mysqli->prepare($sqlT);
    if (!$st2){ json_response(['message'=>'SQL prepare failed (recent_expenditures total): '.$mysqli->error],500); }
    $st2->bind_param($types, ...$params);
    $st2->execute();
    $mt=(float)($st2->get_result()->fetch_row()[0]??0);

    json_response(['data'=>$rows,'month_total'=>$mt]); break; }

  case 'recent_payroll': {
    // Latest 5 payroll entries
    $res = $mysqli->query("SELECT p.id, p.period_month, p.period_year, e.full_name AS employee_name, p.net_salary, p.paid_on FROM salary_payroll p LEFT JOIN employees e ON e.id=p.employee_id ORDER BY p.created_at DESC, p.id DESC LIMIT 5");
    $rows=[]; if($res){ while($r=$res->fetch_assoc()) $rows[]=$r; }
    json_response(['data'=>$rows]); break; }

  default: json_response(['message'=>'Invalid action'],400);
}
