<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_login();
header('Content-Type: application/json');
$mysqli = db();
$action = $_GET['action'] ?? $_POST['action'] ?? 'list';

function ensure_admin() { if (!has_role(['admin','super_admin'])) json_response(['message'=>'Forbidden'], 403); }

switch ($action) {
  case 'list':
    $res = $mysqli->query('SELECT id, name, is_active FROM expenditure_categories ORDER BY name');
    $data = [];
    while ($r = $res->fetch_assoc()) { $data[] = $r; }
    json_response(['data'=>$data]);
    break;
  case 'create':
    ensure_admin();
    if (!validate_csrf($_POST['csrf'] ?? '')) json_response(['message'=>'Invalid CSRF'], 400);
    $name = trim($_POST['name'] ?? ''); if ($name==='') json_response(['message'=>'Name required'], 400);
    $stmt = $mysqli->prepare('INSERT INTO expenditure_categories (name) VALUES (?)');
    $stmt->bind_param('s', $name);
    if (!$stmt->execute()) json_response(['message'=>$stmt->error], 500);
    json_response(['message'=>'Created']);
    break;
  case 'toggle':
    ensure_admin();
    if (!validate_csrf($_POST['csrf'] ?? '')) json_response(['message'=>'Invalid CSRF'], 400);
    $id = (int)($_POST['id'] ?? 0); $active = (int)($_POST['is_active'] ?? 1);
    $stmt = $mysqli->prepare('UPDATE expenditure_categories SET is_active=? WHERE id=?');
    $stmt->bind_param('ii', $active, $id);
    if (!$stmt->execute()) json_response(['message'=>$stmt->error], 500);
    json_response(['message'=>'Updated']);
    break;
  case 'delete':
    ensure_admin();
    if (!validate_csrf($_POST['csrf'] ?? '')) json_response(['message'=>'Invalid CSRF'], 400);
    $id = (int)($_POST['id'] ?? 0);
    $stmt = $mysqli->prepare('DELETE FROM expenditure_categories WHERE id=?');
    $stmt->bind_param('i', $id);
    if (!$stmt->execute()) json_response(['message'=>$stmt->error], 500);
    json_response(['message'=>'Deleted']);
    break;
  default:
    json_response(['message'=>'Invalid action'], 400);
}
