<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_login();
if (!function_exists('sess_branch_id')) { function sess_branch_id(){ return $_SESSION['branch_id'] ?? null; } }
header('Content-Type: application/json');
$mysqli = db();
$action = $_GET['action'] ?? $_POST['action'] ?? 'sales_summary';

function ymd($s){ return preg_match('/^\d{4}-\d{2}-\d{2}$/',$s) ? $s : null; }

switch ($action) {
  case 'sales_summary':
    $period = $_GET['period'] ?? 'day'; // day|week|month
    $from = ymd($_GET['from'] ?? '') ?: date('Y-m-01');
    $to = ymd($_GET['to'] ?? '') ?: date('Y-m-d');
    $grpExpr = 'DATE(invoice_date)';
    if ($period === 'week') $grpExpr = 'YEARWEEK(invoice_date, 1)';
    if ($period === 'month') $grpExpr = 'DATE_FORMAT(invoice_date, "%Y-%m")';
    $stmt = $mysqli->prepare(
      "SELECT $grpExpr grp, COUNT(*) invoices, SUM(grand_total) total
       FROM invoices
       WHERE status IN ('issued','paid') AND invoice_date BETWEEN ? AND ?
       GROUP BY grp ORDER BY grp"
    );
    $stmt->bind_param('ss', $from, $to);
    $stmt->execute();
    $res = $stmt->get_result(); $rows=[]; while($r=$res->fetch_assoc()){ $rows[]=$r; }
    json_response(['data'=>$rows]);
    break;

  case 'sales_by_type':
    $from = ymd($_GET['from'] ?? '') ?: date('Y-m-01');
    $to = ymd($_GET['to'] ?? '') ?: date('Y-m-d');
    $type_id = isset($_GET['type_id']) && $_GET['type_id'] !== '' ? (int)$_GET['type_id'] : null;
    $branch_id = isset($_GET['branch_id']) ? (int)$_GET['branch_id'] : null;

    $where = ["i.status IN ('issued','paid')", 'i.invoice_date BETWEEN ? AND ?'];
    $types = 'ss'; $params = [$from, $to];
    if (!has_role(['admin','super_admin'])) {
      $bid=(int)(sess_branch_id() ?? 0);
      if ($bid > 0) { $where[]='i.branch_id=?'; $types.='i'; $params[]=$bid; }
    } else if (!empty($branch_id)) { $where[]='i.branch_id=?'; $types.='i'; $params[]=$branch_id; }
    if (!empty($type_id)) { $where[] = 'fp.type_id = ?'; $types.='i'; $params[] = $type_id; }

    $sql = "SELECT pt.id AS type_id, COALESCE(pt.name,'Unknown') AS type_name, SUM(ii.line_total) AS total
            FROM invoice_items ii
            JOIN invoices i ON i.id = ii.invoice_id
            LEFT JOIN final_products fp ON fp.id = ii.final_product_id
            LEFT JOIN product_types pt ON pt.id = fp.type_id";
    if ($where) $sql .= ' WHERE '.implode(' AND ', $where);
    $sql .= ' GROUP BY pt.id, pt.name ORDER BY total DESC';
    $stmt=$mysqli->prepare($sql); $stmt->bind_param($types, ...$params); $stmt->execute();
    $res=$stmt->get_result(); $rows=[]; while($r=$res->fetch_assoc()){ $rows[]=$r; }
    json_response(['data'=>$rows]);
    break;

  case 'sales_detail':
    $from = ymd($_GET['from'] ?? '') ?: date('Y-m-01');
    $to = ymd($_GET['to'] ?? '') ?: date('Y-m-d');
    $type_id = isset($_GET['type_id']) && $_GET['type_id'] !== '' ? (int)$_GET['type_id'] : null;
    $finish = trim($_GET['finish'] ?? '');
    $color = trim($_GET['color'] ?? '');
    $len_from = $_GET['len_from'] !== null && $_GET['len_from'] !== '' ? (float)$_GET['len_from'] : null;
    $len_to = $_GET['len_to'] !== null && $_GET['len_to'] !== '' ? (float)$_GET['len_to'] : null;
    $wid_from = $_GET['wid_from'] !== null && $_GET['wid_from'] !== '' ? (float)$_GET['wid_from'] : null;
    $wid_to = $_GET['wid_to'] !== null && $_GET['wid_to'] !== '' ? (float)$_GET['wid_to'] : null;
    $branch_id = isset($_GET['branch_id']) ? (int)$_GET['branch_id'] : null;

    $where = ['i.status IN (\'issued\',\'paid\')','i.invoice_date BETWEEN ? AND ?'];
    $types = 'ss'; $params = [$from,$to];
    if (!has_role(['admin','super_admin'])){
      $bid=(int)(sess_branch_id() ?? 0);
      if ($bid > 0) { $where[]='i.branch_id=?'; $types.='i'; $params[]=$bid; }
    } else if (!empty($branch_id)) { $where[]='i.branch_id=?'; $types.='i'; $params[]=$branch_id; }
    if ($type_id !== null) { $where[]='(ii.final_product_id IS NOT NULL AND fp.type_id=?)'; $types.='i'; $params[]=$type_id; }
    // Only apply attribute filters when we have a final product
    if ($finish !== '') { $where[]='(ii.final_product_id IS NOT NULL AND fp.finish_id=?)'; $types.='s'; $params[]=$finish; }
    if ($color !== '') { $where[]='(ii.final_product_id IS NOT NULL AND fp.color_id=?)'; $types.='s'; $params[]=$color; }
    if ($len_from !== null) { $where[]='(ii.final_product_id IS NOT NULL AND fp.final_length>=?)'; $types.='d'; $params[]=$len_from; }
    if ($len_to !== null) { $where[]='(ii.final_product_id IS NOT NULL AND fp.final_length<=?)'; $types.='d'; $params[]=$len_to; }
    if ($wid_from !== null) { $where[]='(ii.final_product_id IS NOT NULL AND fp.final_height>=?)'; $types.='d'; $params[]=$wid_from; }
    if ($wid_to !== null) { $where[]='(ii.final_product_id IS NOT NULL AND fp.final_height<=?)'; $types.='d'; $params[]=$wid_to; }

    $sql = "SELECT i.invoice_no, i.invoice_date, i.customer_id, c.name AS customer_name,
                   ii.description, ii.qty, ii.unit_price, ii.line_total,
                   fp.finish_id, fp.color_id, fp.final_length AS length, fp.final_height AS width,
                   f.name AS finish_name, co.name AS color_name
            FROM invoice_items ii
            JOIN invoices i ON i.id=ii.invoice_id
            JOIN customers c ON c.id=i.customer_id
            LEFT JOIN final_products fp ON fp.id=ii.final_product_id
            LEFT JOIN finishes f ON f.id=fp.finish_id
            LEFT JOIN colors co ON co.id=fp.color_id";
    if ($where) $sql .= ' WHERE '.implode(' AND ',$where);
    $sql .= ' ORDER BY i.invoice_date, i.id, ii.id';
    $stmt=$mysqli->prepare($sql); $stmt->bind_param($types, ...$params); $stmt->execute();
    $res=$stmt->get_result(); $rows=[]; while($r=$res->fetch_assoc()){ $rows[]=$r; }
    json_response(['data'=>$rows]);
    break;

  case 'outstanding':
    $from = ymd($_GET['from'] ?? '') ?: '1970-01-01';
    $to = ymd($_GET['to'] ?? '') ?: '2999-12-31';
    $next_week = isset($_GET['next_week']) && (int)$_GET['next_week']===1;
    $overdue_days = isset($_GET['overdue_days']) ? (int)$_GET['overdue_days'] : 0; // due-date overdue by N days
    $overdue_invoice_days = isset($_GET['overdue_invoice_days']) ? (int)$_GET['overdue_invoice_days'] : 0; // invoice older than N days
    $branch_id = isset($_GET['branch_id']) ? (int)$_GET['branch_id'] : null;

    // Basic due date logic: Cash/Cheque due same day; Credit assumed 30 days.
    $dueDaysExpr = "CASE WHEN i.payment_term='Credit' THEN 30 ELSE 0 END";
    $dueDateExpr = "DATE_ADD(i.invoice_date, INTERVAL $dueDaysExpr DAY)";
    $where = ["i.status IN ('issued','paid')","i.invoice_date BETWEEN ? AND ?"]; $types='ss'; $params=[$from,$to];
    if (!has_role(['admin','super_admin'])){
      $bid=(int)(sess_branch_id() ?? 0); $where[]='i.branch_id=?'; $types.='i'; $params[]=$bid;
    } else if (!empty($branch_id)) { $where[]='i.branch_id=?'; $types.='i'; $params[]=$branch_id; }
    if ($next_week) { $where[] = $dueDateExpr." BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 7 DAY)"; }
    if ($overdue_days > 0) { $where[] = $dueDateExpr." < DATE_SUB(CURDATE(), INTERVAL ".$overdue_days." DAY)"; }
    if ($overdue_invoice_days > 0) { $where[] = "i.invoice_date < DATE_SUB(CURDATE(), INTERVAL ".$overdue_invoice_days." DAY)"; }

    $sql = "SELECT i.id, i.invoice_no, i.invoice_date, i.payment_term, c.name AS customer_name,
                   i.grand_total,
                   COALESCE(p.paid,0) AS total_paid,
                   GREATEST(i.grand_total - COALESCE(p.paid,0), 0) AS balance,
                   $dueDateExpr AS due_date
            FROM invoices i
            JOIN customers c ON c.id=i.customer_id
            LEFT JOIN (SELECT invoice_id, SUM(amount) paid FROM payments GROUP BY invoice_id) p ON p.invoice_id=i.id";
    if ($where) $sql .= ' WHERE '.implode(' AND ',$where);
    $sql .= ' HAVING balance > 0';
    $sql .= ' ORDER BY due_date, i.invoice_date';
    $stmt=$mysqli->prepare($sql); $stmt->bind_param($types, ...$params); $stmt->execute();
    $res=$stmt->get_result(); $rows=[]; while($r=$res->fetch_assoc()){ $rows[]=$r; }
    json_response(['data'=>$rows]);
    break;

  case 'sales_by_quality':
    $from = ymd($_GET['from'] ?? '') ?: date('Y-m-01');
    $to = ymd($_GET['to'] ?? '') ?: date('Y-m-d');
    $sql = "SELECT COALESCE(fp.quality,'Unknown') quality, SUM(ii.line_total) total
            FROM invoice_items ii
            JOIN invoices i ON i.id=ii.invoice_id
            LEFT JOIN final_products fp ON fp.id=ii.final_product_id
            WHERE i.status IN ('issued','paid') AND i.invoice_date BETWEEN ? AND ?
            GROUP BY COALESCE(fp.quality,'Unknown')
            ORDER BY total DESC";
    $stmt=$mysqli->prepare($sql); $stmt->bind_param('ss',$from,$to); $stmt->execute();
    $res=$stmt->get_result(); $rows=[]; while($r=$res->fetch_assoc()){ $rows[]=$r; }
    json_response(['data'=>$rows]);
    break;

  case 'profit_summary':
    $from = ymd($_GET['from'] ?? '') ?: date('Y-m-01');
    $to = ymd($_GET['to'] ?? '') ?: date('Y-m-d');
    // Per final product sold: compare raw value vs sold amount
    $sql = "SELECT ii.final_product_id,
                   SUM(ii.line_total) sold_total,
                   MAX(rmp.value) raw_value,
                   COALESCE(SUM(ii.line_total),0) - COALESCE(MAX(rmp.value),0) profit
            FROM invoice_items ii
            JOIN invoices i ON i.id=ii.invoice_id
            LEFT JOIN final_products fp ON fp.id=ii.final_product_id
            LEFT JOIN raw_material_products rmp ON rmp.id=fp.rmp_id
            WHERE i.status IN ('issued','paid') AND i.invoice_date BETWEEN ? AND ?
            GROUP BY ii.final_product_id";
    $stmt=$mysqli->prepare($sql); $stmt->bind_param('ss',$from,$to); $stmt->execute();
    $rows=[]; $sold_sum=0; $raw_sum=0; $profit_sum=0; $res=$stmt->get_result();
    while($r=$res->fetch_assoc()){ $rows[]=$r; $sold_sum+=(float)$r['sold_total']; $raw_sum+=(float)$r['raw_value']; $profit_sum+=(float)$r['profit']; }
    json_response(['data'=>$rows, 'totals'=>['sold_total'=>$sold_sum,'raw_value'=>$raw_sum,'profit'=>$profit_sum]]);
    break;

  default:
    json_response(['message'=>'Invalid action'],400);
}
