<?php
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/includes/auth.php';
require_once __DIR__ . '/includes/db.php';

// Ensure DB exists (simple check)
$mysqli = db();

if (!current_user()) {
  header('Location: ' . url_for('login.php'));
  exit;
}

$page = $_GET['page'] ?? 'dashboard';
$allowed = ['attendance','dashboard','users','suppliers','purchase_orders','materials','types','colors','finishes','ship_modes','delivery_terms','payment_terms','shop_settings','expenditures','salary_management','import_raw_materials','polishing','finished_products','slab_cutting','cutting_inventory','customers','sales','invoice_print','reports','competitor_analysis','branches','store_locations','production','designations','backups','company_licenses'];
if (!in_array($page, $allowed, true)) $page = 'dashboard';

include __DIR__ . '/templates/header.php';
?>
<div id="app-wrapper">
  <?php include __DIR__ . '/templates/sidebar.php'; ?>
  <main id="content" class="p-0 w-100">
    <?php include __DIR__ . '/pages/' . $page . '.php'; ?>
  </main>
</div>
<?php include __DIR__ . '/templates/footer.php'; ?>
