<?php
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/includes/auth.php';
require_once __DIR__ . '/includes/db.php';

$errors = [];
// Load shop logo and name for display
$login_logo_url = null; $login_company_name = 'Granite Warehouse';
$__db = db();
$__has_logo = false;
$__chk = $__db->query("SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA='".$__db->real_escape_string(DB_NAME)."' AND TABLE_NAME='shop_settings' AND COLUMN_NAME='logo_url' LIMIT 1");
if ($__chk && $__chk->fetch_row()) { $__has_logo = true; }
$__sql = $__has_logo ? 'SELECT logo_url, company_name FROM shop_settings LIMIT 1' : 'SELECT company_name FROM shop_settings LIMIT 1';
$__res = $__db->query($__sql);
if ($__res) { $__row=$__res->fetch_assoc(); if ($__row){ if ($__has_logo && !empty($__row['logo_url'])) $login_logo_url=$__row['logo_url']; if (!empty($__row['company_name'])) $login_company_name=$__row['company_name']; } }
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!validate_csrf($_POST['csrf'] ?? '')) {
    $errors[] = 'Invalid CSRF token';
  } else {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    if (!$username || !$password) {
      $errors[] = 'Username and password are required';
    } else if (login($username, $password)) {
      header('Location: ' . url_for('index.php'));
      exit;
    } else {
      $errors[] = 'Invalid credentials';
    }
  }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Login - SW Granite</title>
   <link rel="icon" type="image/x-icon" href="<?php echo url_for('assets/uploads/favicon.png'); ?>">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light d-flex align-items-center" style="min-height:100vh;">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-md-4">
        <div class="card shadow-sm">
          <div class="card-body p-4">
            <?php if (!empty($login_logo_url)): ?>
              <div class="text-center mb-2"><img src="<?php echo htmlspecialchars($login_logo_url); ?>" alt="Logo" style="max-height:60px;"></div>
            <?php endif; ?>
            <!-- <h4 class="mb-3 text-center">Sign in</h4> -->
            <?php if ($errors): ?>
              <div class="alert alert-danger">
                <?php foreach ($errors as $e): ?>
                  <div><?php echo htmlspecialchars($e); ?></div>
                <?php endforeach; ?>
              </div>
            <?php endif; ?>
            <form method="post">
              <input type="hidden" name="csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
              <div class="mb-3">
                <label class="form-label">Username</label>
                <input type="text" name="username" class="form-control" required>
              </div>
              <div class="mb-3">
                <label class="form-label">Password</label>
                <input type="password" name="password" class="form-control" required>
              </div>
              <div class="d-grid">
                <button class="btn btn-primary" type="submit">Login</button>
              </div>
            </form>
          </div>
        </div>
        <p class="text-center text-muted mt-3 small">© <?php echo date('Y'); ?> Granite Warehouse</p>
      </div>
    </div>
  </div>
</body>
</html>
