<?php require_once __DIR__ . '/../includes/auth.php'; require_login(); require_once __DIR__ . '/../includes/db.php'; ?>
<div class="page-customers">
  <div class="container-fluid p-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
      <h4>Customers</h4>
      <button id="btnAddCustomer" class="btn btn-primary">Add Customer</button>
    </div>

    <div class="card shadow-sm">
      <div class="card-body">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-3">
          <div class="input-group" style="max-width: 420px;">
            <input type="text" id="custSearch" class="form-control" placeholder="Search by name, phone, email...">
            <button class="btn btn-outline-secondary" id="btnCustSearch"><i class="bi bi-search"></i></button>
          </div>
        </div>
        <div class="table-responsive">
          <table id="customers-table" class="table table-hover align-middle">
            <thead>
              <tr>
                <th>#</th>
                <th>Name</th>
                <th>Company</th>
                <th>Phone</th>
                <th>Email</th>
                <th>City</th>
                <th>Country</th>
                <th>GST No</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody></tbody>
          </table>
        </div>
      </div>
    </div>
  </div>

  <input type="hidden" id="csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>" />

  <div class="modal fade" id="customerModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Customer Details</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form id="customerForm">
          <div class="modal-body">
            <input type="hidden" name="csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
            <input type="hidden" id="customerId" name="id">
            <div class="row g-3">
              <div class="col-md-6">
                <label class="form-label">Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="cust_name" name="name" required>
              </div>
              <div class="col-md-6">
                <label class="form-label">Company</label>
                <input type="text" class="form-control" id="company_name" name="company_name">
              </div>
              <div class="col-md-6">
                <label class="form-label">Phone</label>
                <input type="text" class="form-control" id="cust_phone" name="phone">
              </div>
              <div class="col-md-6">
                <label class="form-label">Email</label>
                <input type="email" class="form-control" id="cust_email" name="email">
              </div>
              <div class="col-12">
                <label class="form-label">Address</label>
                <input type="text" class="form-control" id="cust_address" name="address">
              </div>
              <div class="col-md-4">
                <label class="form-label">City</label>
                <input type="text" class="form-control" id="cust_city" name="city">
              </div>
              <div class="col-md-4">
                <label class="form-label">State</label>
                <input type="text" class="form-control" id="cust_state" name="state">
              </div>
              <div class="col-md-4">
                <label class="form-label">Country</label>
                <input type="text" class="form-control" id="cust_country" name="country">
              </div>
              <div class="col-md-6">
                <label class="form-label">GST No</label>
                <input type="text" class="form-control" id="gst_no" name="gst_no">
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary">Save</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
