<?php require_once __DIR__ . '/../includes/auth.php'; require_login(); ?>
<div class="page-designations">
  <div class="container-fluid p-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
      <h4>Designations</h4>
      <button id="btnAddDesignation" class="btn btn-primary"><i class="bi bi-plus"></i> Add Designation</button>
    </div>

    <div class="card shadow-sm">
      <div class="card-body">
        <div class="table-responsive">
          <table class="table table-hover align-middle" id="desig-table">
            <thead><tr><th>Name</th><th>Status</th><th>Actions</th></tr></thead>
            <tbody></tbody>
          </table>
        </div>
      </div>
    </div>
  </div>

  <input type="hidden" id="csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>" />

  <div class="modal fade" id="desigModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header"><h5 class="modal-title">Designation</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
        <form id="desigForm">
          <div class="modal-body">
            <input type="hidden" name="csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
            <input type="hidden" id="desigId" name="id">
            <div class="mb-2">
              <label class="form-label">Name</label>
              <input type="text" class="form-control" name="name" id="desigName" required>
            </div>
            <div class="form-check mt-2">
              <input class="form-check-input" type="checkbox" id="desigActive" name="is_active" checked>
              <label class="form-check-label" for="desigActive">Active</label>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary">Save</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
(function(){
  const $tbody = $('#desig-table tbody');
  const csrf = $('#csrf').val();

  function fetchDesignations(){
    $.get('api/designations.php', { action:'list' }, function(res){
      $tbody.empty();
      (res.data||[]).forEach(d=>{
        const tr = $('<tr>');
        tr.append(`<td>${$('<div>').text(d.name).html()}</td>`);
        tr.append(`<td>${d.is_active? 'Active':'Inactive'}</td>`);
        tr.append(`<td>
          <button class="btn btn-sm btn-primary me-2 btn-edit" data-id="${d.id}"><i class="bi bi-pencil"></i></button>
          <button class="btn btn-sm btn-danger btn-del" data-id="${d.id}"><i class="bi bi-trash"></i></button>
        </td>`);
        $tbody.append(tr);
      });
    });
  }

  $('#btnAddDesignation').on('click', function(){
    $('#desigForm')[0].reset();
    $('#desigId').val('');
    $('#desigActive').prop('checked', true);
    $('#desigModal').modal('show');
  });

  $('#desig-table').on('click', '.btn-edit', function(){
    const id = $(this).data('id');
    $.get('api/designations.php', { action:'get', id }, function(res){
      const d = res.data||{};
      $('#desigId').val(d.id);
      $('#desigName').val(d.name||'');
      $('#desigActive').prop('checked', !!parseInt(d.is_active));
      $('#desigModal').modal('show');
    });
  });

  $('#desig-table').on('click', '.btn-del', function(){
    if(!confirm('Delete this designation?')) return;
    const id = $(this).data('id');
    $.post('api/designations.php?action=delete', { id, csrf }, function(){ fetchDesignations(); });
  });

  $('#desigForm').on('submit', function(e){
    e.preventDefault();
    const data = $(this).serialize();
    const action = $('#desigId').val() ? 'update' : 'create';
    $.post('api/designations.php?action='+action, data, function(){
      $('#desigModal').modal('hide');
      fetchDesignations();
    }).fail(function(xhr){ alert(xhr.responseJSON?.message || 'Error'); });
  });

  fetchDesignations();
})();
</script>
