<?php require_once __DIR__ . '/../includes/auth.php'; require_login(); ?>
<div class="page-shop_settings">
  <div class="container-fluid p-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
      <h4>Shop Settings</h4>
    </div>
    <div class="card shadow-sm">
      <div class="card-body">
        <form id="shopSettingsForm" class="row g-3" autocomplete="off" enctype="multipart/form-data">
          <input type="hidden" name="csrf" id="csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
          <input type="hidden" name="id" id="shop_id">
          <div class="col-md-6">
            <label class="form-label">Company Name</label>
            <input type="text" class="form-control" id="company_name" name="company_name" required>
          </div>
          <div class="col-md-6">
            <label class="form-label">Phone</label>
            <input type="text" class="form-control" id="phone" name="phone" required>
          </div>
          <div class="col-md-6">
            <label class="form-label">Company Email</label>
            <input type="email" class="form-control" id="company_email" name="company_email">
          </div>
          <div class="col-md-8">
            <label class="form-label">Address Line</label>
            <input type="text" class="form-control" id="address_line" name="address_line" required>
          </div>
          <div class="col-md-4">
            <label class="form-label">City, Country</label>
            <input type="text" class="form-control" id="city_country" name="city_country" required>
          </div>
          <div class="col-md-6">
            <label class="form-label">Shop Logo (PNG/JPG/WEBP, max 5MB)</label>
            <input type="file" class="form-control" id="logo" name="logo" accept="image/png,image/jpeg,image/webp">
          </div>
          <div class="col-md-6 d-flex align-items-end">
            <div>
              <img id="logoPreview" src="" alt="Logo preview" style="max-height:60px; display:none;"/>
            </div>
          </div>
          <div class="col-12">
            <button type="submit" class="btn btn-primary">Save Settings</button>
          </div>
        </form>
        <div class="text-muted small mt-2">Only Admin/Super Admin can update settings.</div>
      </div>
    </div>
  </div>
</div>

<script>
(function(){
  function loadSettings(){
    $.get('api/shop_settings.php', { action:'get' }, function(res){
      const d = res.data||{};
      $('#shop_id').val(d.id||'');
      $('#company_name').val(d.company_name||'');
      $('#phone').val(d.phone||'');
      $('#company_email').val(d.company_email||'');
      $('#address_line').val(d.address_line||'');
      $('#city_country').val(d.city_country||'');
      if (d.logo_url){ $('#logoPreview').attr('src', d.logo_url).show(); }
    });
  }
  $('#logo').on('change', function(e){
    const f = this.files && this.files[0]; if(!f) return;
    const url = URL.createObjectURL(f); $('#logoPreview').attr('src', url).show();
  });
  $('#shopSettingsForm').on('submit', function(e){
    e.preventDefault();
    const fd = new FormData(this); fd.append('action','update');
    $.ajax({ url:'api/shop_settings.php', method:'POST', data:fd, processData:false, contentType:false })
      .done(function(res){
        const d = res.data||{}; if(d.logo_url){ $('#logoPreview').attr('src', d.logo_url).show(); }
        alert('Saved');
      })
      .fail(function(xhr){ alert((xhr.responseJSON&&xhr.responseJSON.message)||'Failed to save'); });
  });
  loadSettings();
})();
</script>
