<?php require_once __DIR__ . '/../includes/auth.php'; require_login(); ?>
<div class="page-suppliers">
<div class="container-fluid p-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4>Suppliers</h4>
    <button id="btnAddSupplier" class="btn btn-primary">Add Supplier</button>
  </div>
  <div class="card shadow-sm">
    <div class="card-body">
      <div class="table-responsive">
        <table id="suppliers-table" class="table table-hover align-middle">
          <thead>
            <tr>
              <th>ID</th>
              <th>Code</th>
              <th>Name</th>
              <th>Contact</th>
              <th>Phone</th>
              <th>Country</th>
              <th>Status</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<input type="hidden" id="csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>" />

<div class="modal fade" id="supplierModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Supplier</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form id="supplierForm">
        <div class="modal-body">
          <input type="hidden" name="csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
          <input type="hidden" id="supplierId" name="id">
          <div class="row g-3">
            <div class="col-md-6">
              <h6 class="text-muted">Basic Information</h6>
              <div class="mb-2">
                <label class="form-label">Supplier Code</label>
                <div class="input-group">
                  <input type="text" class="form-control" id="supplier_code" name="supplier_code" placeholder="Auto-generate if left blank">
                  <button class="btn btn-outline-secondary" type="button" id="btnGenCode">Generate</button>
                </div>
                <small class="text-muted">Leave blank to auto-generate</small>
              </div>
              <div class="mb-2">
                <label class="form-label">Supplier Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="s_name" name="name" required>
              </div>
              <div class="mb-2">
                <label class="form-label">Contact Person</label>
                <input type="text" class="form-control" id="contact_person" name="contact_person">
              </div>
              <div class="mb-2">
                <label class="form-label">Email</label>
                <input type="email" class="form-control" id="email" name="email">
              </div>
              <div class="mb-2">
                <label class="form-label">Phone</label>
                <input type="text" class="form-control" id="phone" name="phone">
              </div>
              <div class="mb-2">
                <label class="form-label">Address</label>
                <textarea class="form-control" id="address" name="address" rows="2"></textarea>
              </div>
            </div>
            <div class="col-md-6">
              <h6 class="text-muted">Location & Business Information</h6>
              <div class="mb-2">
                <label class="form-label">Country</label>
                <select class="form-select" id="country" name="country">
                  <option value="">Select Country</option>
                  <option value="India">India</option>
                  <option value="United States">United States</option>
                  <option value="United Arab Emirates">United Arab Emirates</option>
                  <option value="China">China</option>
                  <option value="Sri Lanka">Sri Lanka</option>
                </select>
              </div>
              <div class="mb-2">
                <label class="form-label">Tax ID / GST Number</label>
                <input type="text" class="form-control" id="tax_id" name="tax_id" placeholder="e.g., 22AAAAA0000A1Z5">
              </div>
              <div class="mb-2">
                <label class="form-label">Payment Terms</label>
                <select class="form-select" id="payment_terms" name="payment_terms">
                  <option value="">Select Payment Terms</option>
                  <option value="Immediate">Immediate</option>
                  <option value="Net 15">Net 15</option>
                  <option value="Net 30">Net 30</option>
                  <option value="Net 45">Net 45</option>
                  <option value="Net 60">Net 60</option>
                </select>
              </div>
              <div class="mb-2">
                <label class="form-label">Currency</label>
                <select class="form-select" id="currency" name="currency">
                  <option value="LKR">Sri Lankan Rupee (LKR)</option>
                  <option value="INR">Indian Rupee (₹)</option>
                  <option value="USD">US Dollar ($)</option>
                  <option value="AED">UAE Dirham (د.إ)</option>
                  <option value="CNY">Chinese Yuan (¥)</option>
                </select>
              </div>
              <div class="form-check form-switch mt-4">
                <input class="form-check-input" type="checkbox" id="is_active" name="is_active" checked>
                <label class="form-check-label" for="is_active">Active Supplier</label>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary">Save</button>
        </div>
      </form>
    </div>
  </div>
</div>
</div>
