<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_login();
header('Content-Type: application/json');
$mysqli = db();
$action = $_GET['action'] ?? $_POST['action'] ?? 'list';

// Migration: add branch_id and designation to employees if missing
function ensure_emp_migration(mysqli $db){
  $res1 = $db->query("SHOW COLUMNS FROM employees LIKE 'branch_id'");
  if (!$res1 || !$res1->fetch_assoc()) {
    @$db->query("ALTER TABLE employees ADD COLUMN branch_id INT NULL AFTER email");
    @$db->query("ALTER TABLE employees ADD CONSTRAINT fk_emp_branch FOREIGN KEY (branch_id) REFERENCES branches(id) ON DELETE SET NULL");
  }
  $res2 = $db->query("SHOW COLUMNS FROM employees LIKE 'designation'");
  if (!$res2 || !$res2->fetch_assoc()) {
    @$db->query("ALTER TABLE employees ADD COLUMN designation VARCHAR(100) NULL AFTER branch_id");
  }
  // add designation_id (FK) for master-based designation
  $res3 = $db->query("SHOW COLUMNS FROM employees LIKE 'designation_id'");
  if (!$res3 || !$res3->fetch_assoc()) {
    @$db->query("ALTER TABLE employees ADD COLUMN designation_id INT NULL AFTER designation");
    @$db->query("CREATE TABLE IF NOT EXISTS designations (id INT AUTO_INCREMENT PRIMARY KEY, name VARCHAR(120) NOT NULL UNIQUE, is_active TINYINT(1) NOT NULL DEFAULT 1, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP) ENGINE=InnoDB");
    @$db->query("ALTER TABLE employees ADD CONSTRAINT fk_emp_designation FOREIGN KEY (designation_id) REFERENCES designations(id) ON DELETE SET NULL");
  }
}

function ensure_admin_emp(){ if (!has_role(['admin','super_admin'])) json_response(['message'=>'Forbidden'], 403); }

switch ($action) {
  case 'list':
    ensure_emp_migration($mysqli);
    $branch_id = isset($_GET['branch_id']) && $_GET['branch_id']!=='' ? (int)$_GET['branch_id'] : 0;
    $where = '';
    $types=''; $params=[];
    if ($branch_id) { $where = ' WHERE e.branch_id=?'; $types='i'; $params[]=$branch_id; }
    $sql = 'SELECT e.id, e.emp_code, e.full_name, e.phone, e.email, e.base_salary, e.is_active, e.branch_id, e.designation, e.designation_id, b.name AS branch_name, d.name AS designation_name FROM employees e LEFT JOIN branches b ON b.id=e.branch_id LEFT JOIN designations d ON d.id=e.designation_id' . $where . ' ORDER BY e.full_name';
    if ($where) { $stmt=$mysqli->prepare($sql); $stmt->bind_param($types, ...$params); $stmt->execute(); $res=$stmt->get_result(); }
    else { $res = $mysqli->query($sql); }
    $data=[]; while($r=$res->fetch_assoc()){ $data[]=$r; }
    json_response(['data'=>$data]);
    break;

  case 'get':
    ensure_emp_migration($mysqli);
    $id=(int)($_GET['id'] ?? 0);
    $stmt=$mysqli->prepare('SELECT * FROM employees WHERE id=?');
    $stmt->bind_param('i',$id); $stmt->execute(); $row=$stmt->get_result()->fetch_assoc();
    json_response(['data'=>$row]);
    break;

  case 'create':
    ensure_admin_emp(); ensure_emp_migration($mysqli); if (!validate_csrf($_POST['csrf'] ?? '')) json_response(['message'=>'Invalid CSRF'],400);
    $emp_code=trim($_POST['emp_code'] ?? '');
    $full_name=trim($_POST['full_name'] ?? ''); if ($full_name==='') json_response(['message'=>'Full name required'],400);
    $phone=trim($_POST['phone'] ?? '');
    $email=trim($_POST['email'] ?? '');
    $branch_id = isset($_POST['branch_id']) && $_POST['branch_id']!=='' ? (int)$_POST['branch_id'] : null;
    $designation_id = isset($_POST['designation_id']) && $_POST['designation_id']!=='' ? (int)$_POST['designation_id'] : null;
    $designation = trim($_POST['designation'] ?? ''); if ($designation==='') $designation = null; // legacy text
    $base_salary=(float)($_POST['base_salary'] ?? 0);
    $is_active=isset($_POST['is_active']) ? 1 : 0;
    $stmt=$mysqli->prepare('INSERT INTO employees (emp_code, full_name, phone, email, branch_id, designation, designation_id, base_salary, is_active) VALUES (?,?,?,?,?,?,?,?,?)');
    $stmt->bind_param('sssssisdi',$emp_code,$full_name,$phone,$email,$branch_id,$designation,$designation_id,$base_salary,$is_active);
    if(!$stmt->execute()) json_response(['message'=>$stmt->error],500);
    json_response(['message'=>'Created']);
    break;

  case 'update':
    ensure_admin_emp(); ensure_emp_migration($mysqli); if (!validate_csrf($_POST['csrf'] ?? '')) json_response(['message'=>'Invalid CSRF'],400);
    $id=(int)($_POST['id'] ?? 0); if(!$id) json_response(['message'=>'Missing id'],400);
    $emp_code=trim($_POST['emp_code'] ?? '');
    $full_name=trim($_POST['full_name'] ?? ''); if ($full_name==='') json_response(['message'=>'Full name required'],400);
    $phone=trim($_POST['phone'] ?? '');
    $email=trim($_POST['email'] ?? '');
    $branch_id = isset($_POST['branch_id']) && $_POST['branch_id']!=='' ? (int)$_POST['branch_id'] : null;
    $designation_id = isset($_POST['designation_id']) && $_POST['designation_id']!=='' ? (int)$_POST['designation_id'] : null;
    $designation = trim($_POST['designation'] ?? ''); if ($designation==='') $designation = null;
    $base_salary=(float)($_POST['base_salary'] ?? 0);
    $is_active=isset($_POST['is_active']) ? 1 : 0;
    $stmt=$mysqli->prepare('UPDATE employees SET emp_code=?, full_name=?, phone=?, email=?, branch_id=?, designation=?, designation_id=?, base_salary=?, is_active=? WHERE id=?');
    $stmt->bind_param('ssssissdii',$emp_code,$full_name,$phone,$email,$branch_id,$designation,$designation_id,$base_salary,$is_active,$id);
    if(!$stmt->execute()) json_response(['message'=>$stmt->error],500);
    json_response(['message'=>'Updated']);
    break;

  case 'delete':
    ensure_admin_emp(); if (!validate_csrf($_POST['csrf'] ?? '')) json_response(['message'=>'Invalid CSRF'],400);
    $id=(int)($_POST['id'] ?? 0); if(!$id) json_response(['message'=>'Missing id'],400);
    $stmt=$mysqli->prepare('DELETE FROM employees WHERE id=?');
    $stmt->bind_param('i',$id);
    if(!$stmt->execute()) json_response(['message'=>$stmt->error],500);
    json_response(['message'=>'Deleted']);
    break;

  default:
    json_response(['message'=>'Invalid action'],400);
}
