<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_login();
header('Content-Type: application/json');
$mysqli = db();
$action = $_GET['action'] ?? $_POST['action'] ?? 'list';

function ensure_admin_fp(){ if (!has_role(['admin','super_admin'])) json_response(['message'=>'Forbidden'], 403); }

function sess_branch_id(){ return $_SESSION['branch_id'] ?? null; }
function is_admin_user(){ return has_role(['admin','super_admin']); }

// ensure branch_id column exists for legacy DBs
// @$mysqli->query("ALTER TABLE final_products ADD COLUMN branch_id INT NULL");

switch ($action) {
  case 'list':
    $q = trim($_GET['q'] ?? '');
    $status = trim($_GET['sale_status'] ?? '');
    $branch_id = isset($_GET['branch_id']) ? (int)$_GET['branch_id'] : null;
    $where=[]; $types=''; $params=[];
    if ($q !== '') {
      $where[] = '((p.order_no LIKE CONCAT("%", ?, "%")) OR (r.slab_no LIKE CONCAT("%", ?, "%")))';
      $types.='ss';
      $params[]=$q; $params[]=$q;
    }
    if ($status !== '' && in_array($status, ['available','reserved','sold'], true)) { $where[]='f.sale_status=?'; $types.='s'; $params[]=$status; }
    // Branch scoping
    if (!is_admin_user()){
      $bid = (int)(sess_branch_id() ?? 0); $where[]='(f.branch_id=? OR f.branch_id IS NULL)'; $types.='i'; $params[]=$bid;
    } else if (!empty($branch_id)) { $where[]='f.branch_id=?'; $types.='i'; $params[]=$branch_id; }
    // Use completed_at (set by polishing completion). Some legacy DBs may not have ready_at.
    $sql = 'SELECT f.id, f.final_height, f.final_length, f.final_sq_ft, f.final_sq_m2, f.sale_status, f.completed_at,
                   r.slab_no, r.quality, p.order_no, fn.name AS finish_name,
                   pt.name AS type_name, c.name AS color_name,
                   pj.pre_height, pj.pre_length, pj.worker_name
            FROM final_products f
            LEFT JOIN raw_material_products r ON r.id=f.rmp_id
            LEFT JOIN purchase_orders p ON p.id=f.po_id
            LEFT JOIN finishes fn ON fn.id=f.finish_id
            LEFT JOIN product_types pt ON pt.id=f.type_id
            LEFT JOIN colors c ON c.id=f.color_id
            LEFT JOIN polishing_jobs pj ON pj.id=f.polishing_job_id';
    if ($where) $sql .= ' WHERE ' . implode(' AND ', $where);
    $sql .= ' ORDER BY f.id DESC';
    if ($where){ $stmt=$mysqli->prepare($sql); $stmt->bind_param($types, ...$params); $stmt->execute(); $res=$stmt->get_result(); }
    else { $res=$mysqli->query($sql); }
    $rows=[]; while($row=$res->fetch_assoc()){ $rows[]=$row; }
    json_response(['data'=>$rows]);
    break;

  case 'get':
    $id=(int)($_GET['id'] ?? 0);
    $stmt=$mysqli->prepare('SELECT * FROM final_products WHERE id=?');
    $stmt->bind_param('i',$id); $stmt->execute(); $row=$stmt->get_result()->fetch_assoc();
    if(!$row) json_response(['message'=>'Not found'],404);
    if (!is_admin_user()){
      $bid=(int)(sess_branch_id() ?? 0); if ((int)($row['branch_id'] ?? 0) !== $bid) json_response(['message'=>'Forbidden'],403);
    }
    json_response(['data'=>$row]);
    break;

  case 'detail':
    $id=(int)($_GET['id'] ?? 0); if(!$id) json_response(['message'=>'Missing id'],400);
    $sql = 'SELECT f.*, fn.name AS finish_name,
                   r.slab_no, r.quality AS raw_quality, r.height AS pre_height_raw, r.length AS pre_length_raw, r.sq_ft AS pre_sqft_raw,
                   p.order_no,
                   pj.pre_height, pj.pre_length, pj.worker_name, pj.start_at, pj.end_at
            FROM final_products f
            LEFT JOIN raw_material_products r ON r.id=f.rmp_id
            LEFT JOIN purchase_orders p ON p.id=f.po_id
            LEFT JOIN finishes fn ON fn.id=f.finish_id
            LEFT JOIN polishing_jobs pj ON pj.id=f.polishing_job_id
            WHERE f.id=?';
    $stmt=$mysqli->prepare($sql); $stmt->bind_param('i',$id); $stmt->execute();
    $row=$stmt->get_result()->fetch_assoc(); if(!$row) json_response(['message'=>'Not found'],404);
    if (!is_admin_user()){
      $bid=(int)(sess_branch_id() ?? 0); if ((int)($row['branch_id'] ?? 0) !== $bid) json_response(['message'=>'Forbidden'],403);
    }
    json_response(['data'=>$row]);
    break;

  case 'update_status':
    ensure_admin_fp();
    if (!validate_csrf($_POST['csrf'] ?? '')) json_response(['message'=>'Invalid CSRF'], 400);
    $id=(int)($_POST['id'] ?? 0); $status=trim($_POST['sale_status'] ?? '');
    if(!$id || !in_array($status, ['available','reserved','sold'], true)) json_response(['message'=>'Invalid input'],400);
    $stmt=$mysqli->prepare('UPDATE final_products SET sale_status=? WHERE id=?');
    $stmt->bind_param('si',$status,$id);
    if(!$stmt->execute()) json_response(['message'=>$stmt->error],500);
    json_response(['message'=>'Updated']);
    break;

  case 'update':
    ensure_admin_fp();
    if (!validate_csrf($_POST['csrf'] ?? '')) json_response(['message'=>'Invalid CSRF'], 400);
    $id=(int)($_POST['id'] ?? 0); if(!$id) json_response(['message'=>'Missing id'],400);
    $final_height = ($_POST['final_height'] === '' ? null : (float)$_POST['final_height']);
    $final_length = ($_POST['final_length'] === '' ? null : (float)$_POST['final_length']);
    $finish_id = ($_POST['finish_id'] === '' ? null : (int)$_POST['finish_id']);
    $quality = trim($_POST['quality'] ?? ''); if($quality==='') $quality=null;
    $final_sq_ft = null; $final_sq_m2 = null;
    if ($final_height !== null && $final_length !== null) {
      $final_sq_ft = $final_height * $final_length; // assuming H and L in feet
    }
    $stmt=$mysqli->prepare('UPDATE final_products SET final_height=?, final_length=?, final_sq_ft=?, final_sq_m2=?, finish_id=?, quality=? WHERE id=?');
    $stmt->bind_param('dddddsi', $final_height, $final_length, $final_sq_ft, $final_sq_m2, $finish_id, $quality, $id);
    if(!$stmt->execute()) json_response(['message'=>$stmt->error],500);
    json_response(['message'=>'Updated']);
    break;

  default:
    json_response(['message'=>'Invalid action'],400);
}
