<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_login();
header('Content-Type: application/json');
$mysqli = db();

$action = $_REQUEST['action'] ?? 'list';

function ensure_admin_fp(){ if (!has_role(['admin','super_admin'])) json_response(['message'=>'Forbidden'], 403); }

switch ($action) {
  case 'list': {
    $params=[]; $types=''; $wheres=[];
    $min_h = $_GET['min_h'] ?? ''; $max_h = $_GET['max_h'] ?? '';
    $min_l = $_GET['min_l'] ?? ''; $max_l = $_GET['max_l'] ?? '';
    $min_sqf = $_GET['min_sqf'] ?? ''; $max_sqf = $_GET['max_sqf'] ?? '';
    $type_id = (int)($_GET['type_id'] ?? 0); $color_id=(int)($_GET['color_id'] ?? 0);
    $branch_id=(int)($_GET['branch_id'] ?? 0); $store_id=(int)($_GET['store_location_id'] ?? 0);
    if ($min_h!==''){ $wheres[]='f.final_height>=?'; $types.='d'; $params[]=$min_h; }
    if ($max_h!==''){ $wheres[]='f.final_height<=?'; $types.='d'; $params[]=$max_h; }
    if ($min_l!==''){ $wheres[]='f.final_length>=?'; $types.='d'; $params[]=$min_l; }
    if ($max_l!==''){ $wheres[]='f.final_length<=?'; $types.='d'; $params[]=$max_l; }
    if ($min_sqf!==''){ $wheres[]='f.final_sq_ft>=?'; $types.='d'; $params[]=$min_sqf; }
    if ($max_sqf!==''){ $wheres[]='f.final_sq_ft<=?'; $types.='d'; $params[]=$max_sqf; }
    if ($type_id){ $wheres[]='f.type_id=?'; $types.='i'; $params[]=$type_id; }
    if ($color_id){ $wheres[]='f.color_id=?'; $types.='i'; $params[]=$color_id; }
    if ($branch_id){ $wheres[]='f.branch_id=?'; $types.='i'; $params[]=$branch_id; }
    if ($store_id){ $wheres[]='f.store_location_id=?'; $types.='i'; $params[]=$store_id; }

    $sql = 'SELECT f.*, r.slab_no, p.order_no, fn.name AS finish_name, pt.name AS type_name, c.name AS color_name,
                   b.name AS branch_name, s.name AS store_name
            FROM final_products f
            LEFT JOIN raw_material_products r ON r.id=f.rmp_id
            LEFT JOIN purchase_orders p ON p.id=f.po_id
            LEFT JOIN finishes fn ON fn.id=f.finish_id
            LEFT JOIN product_types pt ON pt.id=f.type_id
            LEFT JOIN colors c ON c.id=f.color_id
            LEFT JOIN branches b ON b.id=f.branch_id
            LEFT JOIN store_locations s ON s.id=f.store_location_id';
    // Branch scoping: non-admin users see their branch; include legacy rows with NULL branch_id
    $cu = current_user();
    if ($cu && !has_role(['admin','super_admin']) && !empty($cu['branch_id'])) {
      $wheres[] = '(f.branch_id=? OR f.branch_id IS NULL)'; $types.='i'; $params[] = (int)$cu['branch_id'];
    }
    if ($wheres) $sql .= ' WHERE ' . implode(' AND ', $wheres);
    $sql .= ' ORDER BY f.id DESC';
    if ($wheres){ $stmt=$mysqli->prepare($sql); $stmt->bind_param($types, ...$params); $stmt->execute(); $res=$stmt->get_result(); }
    else { $res=$mysqli->query($sql); }
    $rows=[]; while($row=$res->fetch_assoc()) $rows[]=$row; json_response(['data'=>$rows]);
    }
    break;

  case 'get': {
    $id=(int)($_GET['id']??0); if(!$id) json_response(['message'=>'ID required'],422);
    $stmt=$mysqli->prepare('SELECT * FROM final_products WHERE id=?'); $stmt->bind_param('i',$id); $stmt->execute();
    $row=$stmt->get_result()->fetch_assoc(); json_response(['data'=>$row]);
    }
    break;

  case 'detail': {
    $id=(int)($_GET['id']??0); if(!$id) json_response(['message'=>'ID required'],422);
    $sql='SELECT 
            f.*, 
            r.id AS rmp_internal_id, r.slab_no, r.height AS raw_height, r.length AS raw_length, r.sq_ft AS raw_sq_ft, r.quality AS raw_quality,
            p.order_no, p.order_date, p.ship_mode, p.delivery_term, p.payment_term,
            sup.name AS supplier_name,
            fn.name AS finish_name,
            pt.name AS type_name,
            c.name AS color_name,
            b.name AS branch_name,
            s.name AS store_name,
            pj.pre_height, pj.pre_length, pj.worker_name, pj.start_at, pj.end_at
          FROM final_products f
          LEFT JOIN raw_material_products r ON r.id=f.rmp_id
          LEFT JOIN purchase_orders p ON p.id=f.po_id
          LEFT JOIN suppliers sup ON sup.id=p.supplier_id
          LEFT JOIN finishes fn ON fn.id=f.finish_id
          LEFT JOIN product_types pt ON pt.id=f.type_id
          LEFT JOIN colors c ON c.id=f.color_id
          LEFT JOIN branches b ON b.id=f.branch_id
          LEFT JOIN store_locations s ON s.id=f.store_location_id
          LEFT JOIN polishing_jobs pj ON pj.id=f.polishing_job_id
          WHERE f.id=?';
    $stmt=$mysqli->prepare($sql); $stmt->bind_param('i',$id); $stmt->execute(); $row=$stmt->get_result()->fetch_assoc();
    if(!$row) json_response(['message'=>'Not found'],404);
    json_response(['data'=>$row]);
    }
    break;

  case 'create':
    ensure_admin_fp();
    $stmt=$mysqli->prepare('INSERT INTO final_products (rmp_id, po_id, polishing_job_id, final_height, final_length, final_sq_ft, final_sq_m2, finish_id, quality, sale_status, branch_id, store_location_id, type_id, color_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
    $stmt->bind_param('iiidd dddis s i i i i', $rmp_id, $po_id, $polishing_job_id, $final_height, $final_length, $final_sq_ft, $final_sq_m2, $finish_id, $quality, $sale_status, $branch_id, $store_location_id, $type_id, $color_id);
    json_response(['message'=>'Not implemented'],501);
    break;

  case 'update':
    ensure_admin_fp();
    $id=(int)($_POST['id']??0); if(!$id) json_response(['message'=>'ID required'],422);
    $fields=['final_height','final_length','final_sq_ft','final_sq_m2','finish_id','quality','sale_status','branch_id','store_location_id','type_id','color_id'];
    $sets=[]; $types=''; $params=[];
    foreach ($fields as $f){ if (isset($_POST[$f]) && $_POST[$f] !== '') { $sets[] = "{$f}=?"; $types .= in_array($f,['quality','sale_status'])?'s':'i'; $params[] = $_POST[$f]; } }
    if (!$sets) json_response(['ok'=>true]);
    $types .= 'i'; $params[]=$id;
    $sql='UPDATE final_products SET '.implode(',', $sets).' WHERE id=?';
    $stmt=$mysqli->prepare($sql); $stmt->bind_param($types, ...$params); $stmt->execute(); json_response(['ok'=>true]);
    break;

  case 'delete':
    ensure_admin_fp();
    $id=(int)($_POST['id']??0); if(!$id) json_response(['message'=>'ID required'],422);
    $mysqli->query('DELETE FROM final_products WHERE id='.(int)$id);
    json_response(['ok'=>true]);
    break;

  case 'options': { // for filters selects
    $types=[]; $res=$mysqli->query('SELECT id, name FROM product_types ORDER BY name'); while($r=$res->fetch_assoc()) $types[]=$r;
    $colors=[]; $res=$mysqli->query('SELECT id, name FROM colors ORDER BY name'); while($r=$res->fetch_assoc()) $colors[]=$r;
    $branches=[]; $res=$mysqli->query('SELECT id, name FROM branches WHERE is_active=1 ORDER BY name'); while($r=$res->fetch_assoc()) $branches[]=$r;
    // Include branch_id with stores so UI can filter stores by selected branch
    $stores=[]; $res=$mysqli->query('SELECT id, name, branch_id FROM store_locations WHERE is_active=1 ORDER BY name'); while($r=$res->fetch_assoc()) $stores[]=$r;
    json_response(['types'=>$types,'colors'=>$colors,'branches'=>$branches,'stores'=>$stores]);
    }
    break;

  default:
    json_response(['message'=>'Invalid action'],400);
}
