<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_login();
header('Content-Type: application/json');

$mysqli = db();
$action = $_GET['action'] ?? $_POST['action'] ?? 'get';

function ensure_admin_settings() { if (!has_role(['admin','super_admin'])) json_response(['message'=>'Forbidden'], 403); }

// Ensure a row exists
function ensure_row($mysqli){
  $res = $mysqli->query('SELECT id FROM shop_settings LIMIT 1');
  if ($res && $row = $res->fetch_assoc()) return (int)$row['id'];
  $mysqli->query("INSERT INTO shop_settings (company_name,address_line,city_country,company_email,phone) VALUES ('Granite Warehouse','Warehouse Address Line','City, Country','', '-')");
  return (int)$mysqli->insert_id;
}

switch ($action) {
  case 'get':
    $id = ensure_row($mysqli);
    $stmt = $mysqli->prepare('SELECT id, company_name, address_line, city_country, company_email, phone FROM shop_settings WHERE id = ?');
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $row = $stmt->get_result()->fetch_assoc();
    json_response(['data' => $row]);
    break;
  case 'update':
    ensure_admin_settings();
    if (!validate_csrf($_POST['csrf'] ?? '')) json_response(['message' => 'Invalid CSRF'], 400);
    $id = (int)($_POST['id'] ?? 0);
    if (!$id) { $id = ensure_row($mysqli); }
    $company_name = trim($_POST['company_name'] ?? '');
    $address_line = trim($_POST['address_line'] ?? '');
    $city_country = trim($_POST['city_country'] ?? '');
    $company_email = trim($_POST['company_email'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    if ($company_name === '' || $address_line === '' || $city_country === '' || $phone === '') {
      json_response(['message' => 'All fields are required'], 400);
    }
    $stmt = $mysqli->prepare('UPDATE shop_settings SET company_name=?, address_line=?, city_country=?, company_email=?, phone=? WHERE id=?');
    $stmt->bind_param('sssssi', $company_name, $address_line, $city_country, $company_email, $phone, $id);
    if (!$stmt->execute()) json_response(['message'=>$stmt->error], 500);
    json_response(['message'=>'Updated']);
    break;
  default:
    json_response(['message'=>'Invalid action'], 400);
}
