-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Oct 21, 2025 at 07:50 AM
-- Server version: 10.4.32-MariaDB
-- PHP Version: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `granite_warehouse`
--

-- --------------------------------------------------------

--
-- Table structure for table `branches`
--

CREATE TABLE `branches` (
  `id` int(11) NOT NULL,
  `name` varchar(150) NOT NULL,
  `address` varchar(255) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `branches`
--

INSERT INTO `branches` (`id`, `name`, `address`, `phone`, `is_active`, `created_at`) VALUES
(1, 'SW Granite Kandy', 'Kandy', '0712270145', 1, '2025-10-08 13:33:41'),
(2, 'SW Granite Yakkala', 'Yakkala', '0712270145', 1, '2025-10-08 13:33:58'),
(3, 'SW Granite Rathnapura', 'Rathnapura', '0712270145', 1, '2025-10-08 13:34:25');

-- --------------------------------------------------------

--
-- Table structure for table `colors`
--

CREATE TABLE `colors` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `colors`
--

INSERT INTO `colors` (`id`, `name`, `created_at`) VALUES
(1, 'White', '2025-10-16 03:52:58'),
(2, 'Black', '2025-10-16 03:53:05'),
(3, 'Green', '2025-10-16 03:53:12');

-- --------------------------------------------------------

--
-- Table structure for table `customers`
--

CREATE TABLE `customers` (
  `id` int(11) NOT NULL,
  `name` varchar(150) NOT NULL,
  `company_name` varchar(150) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `email` varchar(150) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `gst_no` varchar(50) DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `customers`
--

INSERT INTO `customers` (`id`, `name`, `company_name`, `phone`, `email`, `address`, `city`, `state`, `country`, `gst_no`, `branch_id`, `created_at`) VALUES
(1, 'shanaka', 'acb', '0712270145', 'passdsandaruwan@gmail.com', '32(586/F)', 'Kalawana', 'Rathnapura', 'Sri Lanka', '', 1, '2025-10-16 17:20:59'),
(2, 'shanaka yakkala', 'aaaa', '0712270145', 'isanka.jeewani.ij.ij@gmail.com', '32(586/F)', 'Kalawana', 'Rathnapura', 'Sri Lanka', '', 2, '2025-10-17 05:08:04');

-- --------------------------------------------------------

--
-- Table structure for table `cutting_jobs`
--


CREATE TABLE `cutting_jobs` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `job_date` DATE NOT NULL DEFAULT (CURDATE()),
  `source_type` ENUM('raw', 'finished') NOT NULL,
  `source_id` INT(11) NOT NULL,
  `from_location_id` INT(11) DEFAULT NULL,
  `to_location_id` INT(11) DEFAULT NULL,
  `operator_name` VARCHAR(150) DEFAULT NULL,
  `notes` VARCHAR(255) DEFAULT NULL,
  `status` ENUM('pending', 'completed', 'cancelled') NOT NULL DEFAULT 'completed',
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_source_id` (`source_id`),
  KEY `idx_from_location_id` (`from_location_id`),
  KEY `idx_to_location_id` (`to_location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- --------------------------------------------------------

--
-- Table structure for table `cut_pieces`
--

CREATE TABLE `cut_pieces` (
  `id` int(11) NOT NULL,
  `job_id` int(11) NOT NULL,
  `parent_piece_id` int(11) DEFAULT NULL,
  `piece_no` tinyint(4) NOT NULL,
  `length_mm` decimal(12,2) NOT NULL,
  `width_mm` decimal(12,2) NOT NULL,
  `thickness_mm` decimal(12,2) DEFAULT NULL,
  `area_sq_ft` decimal(12,3) NOT NULL,
  `status` enum('usable','unusable') NOT NULL DEFAULT 'usable',
  `store_location_id` int(11) DEFAULT NULL,
  `is_available` tinyint(1) NOT NULL DEFAULT 1,
  `reserved_invoice_item_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `branch_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `delivery_terms`
--

CREATE TABLE `delivery_terms` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `delivery_terms`
--

INSERT INTO `delivery_terms` (`id`, `name`, `created_at`) VALUES
(1, 'Works', '2025-10-07 14:05:10'),
(2, 'FOB', '2025-10-07 14:05:23'),
(3, 'CNF', '2025-10-07 14:05:36'),
(4, 'CIF', '2025-10-07 14:05:48');

-- --------------------------------------------------------

--
-- Table structure for table `designations`
--

CREATE TABLE `designations` (
  `id` int(11) NOT NULL,
  `name` varchar(120) NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `designations`
--

INSERT INTO `designations` (`id`, `name`, `is_active`, `created_at`) VALUES
(1, 'Polisher', 1, '2025-10-16 09:57:31'),
(2, 'Cutter', 1, '2025-10-16 09:57:36'),
(4, 'Cashire', 1, '2025-10-16 09:58:35'),
(5, 'Supervisor', 1, '2025-10-16 10:06:07');

-- --------------------------------------------------------

--
-- Table structure for table `employees`
--

CREATE TABLE `employees` (
  `id` int(11) NOT NULL,
  `emp_code` varchar(50) DEFAULT NULL,
  `full_name` varchar(150) NOT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `email` varchar(120) DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `designation` varchar(100) DEFAULT NULL,
  `designation_id` int(11) DEFAULT NULL,
  `base_salary` decimal(12,2) DEFAULT 0.00,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `employees`
--

INSERT INTO `employees` (`id`, `emp_code`, `full_name`, `phone`, `email`, `branch_id`, `designation`, `designation_id`, `base_salary`, `is_active`, `created_at`) VALUES
(1, '1007', 'shanaka', '0712270145', 'passdsandaruwan@gmail.com', 2, NULL, 1, 46000.00, 1, '2025-10-16 09:42:47');

-- --------------------------------------------------------

--
-- Table structure for table `expenditures`
--

CREATE TABLE `expenditures` (
  `id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `expense_date` date NOT NULL,
  `description` varchar(255) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `vendor` varchar(150) DEFAULT NULL,
  `invoice_no` varchar(100) DEFAULT NULL,
  `receipt_path` varchar(255) DEFAULT NULL,
  `is_recurring` tinyint(1) NOT NULL DEFAULT 0,
  `notes` text DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `expenditures`
--

INSERT INTO `expenditures` (`id`, `category_id`, `expense_date`, `description`, `amount`, `payment_method`, `vendor`, `invoice_no`, `receipt_path`, `is_recurring`, `notes`, `created_by`, `branch_id`, `created_at`) VALUES
(1, 10, '2025-10-16', 'light bill', 14500.00, 'Cash', 'CEB', '21544369', NULL, 0, '', 1, 1, '2025-10-16 09:41:39');

-- --------------------------------------------------------

--
-- Table structure for table `expenditure_categories`
--

CREATE TABLE `expenditure_categories` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `expenditure_categories`
--

INSERT INTO `expenditure_categories` (`id`, `name`, `is_active`, `created_at`) VALUES
(8, 'Employee Salaries', 1, '2025-10-07 17:12:28'),
(9, 'Utilities', 1, '2025-10-07 17:13:00'),
(10, 'Office Supplies', 1, '2025-10-07 17:13:11'),
(11, 'Transportation', 1, '2025-10-07 17:13:22'),
(12, 'Rent & Facilities', 1, '2025-10-07 17:13:32'),
(13, 'Marketing & Advertising', 1, '2025-10-07 17:13:42'),
(14, 'Professional Services', 1, '2025-10-07 17:13:52'),
(15, 'Insurance', 1, '2025-10-07 17:14:06'),
(16, 'Taxes & Licenses', 1, '2025-10-07 17:14:19'),
(17, 'Equipment & Machinery', 1, '2025-10-07 17:16:36'),
(18, 'Raw Material Transport', 1, '2025-10-07 17:16:45'),
(19, 'Miscellaneous', 1, '2025-10-07 17:16:53');

-- --------------------------------------------------------

--
-- Table structure for table `final_products`
--

CREATE TABLE `final_products` (
  `id` int(11) NOT NULL,
  `rmp_id` int(11) NOT NULL,
  `po_id` int(11) NOT NULL,
  `polishing_job_id` int(11) NOT NULL,
  `pre_height` decimal(12,3) DEFAULT NULL,
  `pre_length` decimal(12,3) DEFAULT NULL,
  `pre_sq_ft` double DEFAULT NULL,
  `pre_sq_m2` double DEFAULT NULL,
  `final_height` decimal(12,3) NOT NULL,
  `final_length` decimal(12,3) NOT NULL,
  `final_sq_ft` decimal(12,3) DEFAULT NULL,
  `final_sq_m2` decimal(12,3) DEFAULT NULL,
  `finish_id` int(11) DEFAULT NULL,
  `type_id` int(11) DEFAULT NULL,
  `color_id` int(11) DEFAULT NULL,
  `polisher_id` int(11) DEFAULT NULL,
  `polisher_name` varchar(150) DEFAULT NULL,
  `quality` varchar(50) DEFAULT NULL,
  `sale_status` enum('available','reserved','sold') NOT NULL DEFAULT 'available',
  `branch_id` int(11) DEFAULT NULL,
  `store_location_id` int(11) DEFAULT NULL,
  `ready_at` datetime DEFAULT current_timestamp(),
  `completed_at` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `final_products`
--

INSERT INTO `final_products` (`id`, `rmp_id`, `po_id`, `polishing_job_id`, `pre_height`, `pre_length`, `pre_sq_ft`, `pre_sq_m2`, `final_height`, `final_length`, `final_sq_ft`, `final_sq_m2`, `finish_id`, `type_id`, `color_id`, `polisher_id`, `polisher_name`, `quality`, `sale_status`, `branch_id`, `store_location_id`, `ready_at`, `completed_at`, `created_at`) VALUES
(2, 23, 2, 4, 23.000, 48.000, 7.666, 0, 24.000, 48.000, 7.000, 107.024, 2, 3, 2, NULL, NULL, 'Premium', 'available', 2, 2, '2025-10-16 17:45:02', '2025-10-16 00:00:00', '2025-10-16 12:15:02'),
(3, 13, 2, 5, 23.000, 47.000, 7.67, 0, 23.000, 47.000, 7.000, 0.730, 3, 3, 2, NULL, NULL, 'Premium', 'available', 2, 2, '2025-10-16 20:13:48', '2025-10-16 00:00:00', '2025-10-16 14:43:48'),
(4, 15, 2, 6, 23.000, 47.000, 7.67, 0, 23.000, 47.000, 7.000, 0.710, 2, 3, 3, NULL, NULL, 'Premium', 'available', 2, 3, '2025-10-16 20:18:58', '2025-10-16 00:00:00', '2025-10-16 14:48:58'),
(5, 14, 2, 7, 23.000, 47.000, 7.67, 0, 23.000, 47.000, 7.000, 0.700, 2, 3, 2, NULL, NULL, 'Premium', 'available', 2, 2, '2025-10-16 20:20:54', '2025-10-16 00:00:00', '2025-10-16 14:50:54'),
(6, 25, 2, 8, 25.000, 49.000, 8.51, 0, 24.000, 47.000, 7.000, 0.730, 2, 3, 2, NULL, NULL, 'Premium', 'available', 1, 4, '2025-10-16 20:26:17', '2025-10-16 00:00:00', '2025-10-16 14:56:17'),
(7, 27, 2, 9, 25.000, 47.000, 8.16, 0, 26.000, 47.000, 8.000, 0.790, 4, 5, 2, NULL, NULL, 'Premium', 'available', 1, 4, '2025-10-17 10:30:26', '2025-10-17 00:00:00', '2025-10-17 05:00:26'),
(8, 22, 2, 10, 23.000, 49.000, 7.83, 0, 24.000, 50.000, 9.000, 0.770, 4, 5, 2, NULL, NULL, 'Premium', 'available', 2, 2, '2025-10-17 10:31:53', '2025-10-17 00:00:00', '2025-10-17 05:01:53');

-- --------------------------------------------------------

--
-- Table structure for table `finishes`
--

CREATE TABLE `finishes` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `finishes`
--

INSERT INTO `finishes` (`id`, `name`, `created_at`) VALUES
(1, 'Brush', '2025-10-16 04:00:46'),
(2, 'Premium', '2025-10-16 04:00:56'),
(3, 'B Grade', '2025-10-16 04:01:09'),
(4, 'A Grade', '2025-10-16 04:01:18');

-- --------------------------------------------------------

--
-- Table structure for table `imports`
--

CREATE TABLE `imports` (
  `id` int(11) NOT NULL,
  `po_id` int(11) NOT NULL,
  `import_date` date NOT NULL,
  `reference_no` varchar(100) DEFAULT NULL,
  `transporter` varchar(150) DEFAULT NULL,
  `vehicle_no` varchar(50) DEFAULT NULL,
  `warehouse` varchar(150) DEFAULT NULL,
  `notes` varchar(255) DEFAULT NULL,
  `attachment_path` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `import_items`
--

CREATE TABLE `import_items` (
  `id` int(11) NOT NULL,
  `import_id` int(11) NOT NULL,
  `po_item_id` int(11) NOT NULL,
  `material_id` int(11) DEFAULT NULL,
  `qty_received` decimal(12,3) NOT NULL DEFAULT 0.000,
  `batch_no` varchar(100) DEFAULT NULL,
  `remarks` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `inventory_moves`
--

CREATE TABLE `inventory_moves` (
  `id` int(11) NOT NULL,
  `from_location_id` int(11) DEFAULT NULL,
  `to_location_id` int(11) DEFAULT NULL,
  `ref_type` varchar(50) NOT NULL,
  `ref_id` int(11) NOT NULL,
  `quantity` decimal(12,3) NOT NULL DEFAULT 0.000,
  `unit` varchar(20) NOT NULL DEFAULT 'sqft',
  `notes` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `invoices`
--

CREATE TABLE `invoices` (
  `id` int(11) NOT NULL,
  `invoice_no` varchar(50) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `invoice_date` date NOT NULL,
  `status` enum('draft','issued','paid','cancelled') NOT NULL DEFAULT 'draft',
  `payment_term` varchar(20) DEFAULT NULL,
  `subtotal` decimal(14,2) NOT NULL DEFAULT 0.00,
  `tax_percent` decimal(5,2) NOT NULL DEFAULT 0.00,
  `tax_amount` decimal(14,2) NOT NULL DEFAULT 0.00,
  `transport_charges` decimal(12,2) NOT NULL DEFAULT 0.00,
  `discount_percent` decimal(6,3) DEFAULT NULL,
  `discount` decimal(14,2) NOT NULL DEFAULT 0.00,
  `grand_total` decimal(14,2) NOT NULL DEFAULT 0.00,
  `currency` char(3) NOT NULL DEFAULT 'LKR',
  `notes` varchar(255) DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `invoices`
--

INSERT INTO `invoices` (`id`, `invoice_no`, `customer_id`, `invoice_date`, `status`, `payment_term`, `subtotal`, `tax_percent`, `tax_amount`, `transport_charges`, `discount_percent`, `discount`, `grand_total`, `currency`, `notes`, `branch_id`, `created_at`) VALUES
(3, 'INV-202510-0001', 2, '2025-10-17', 'cancelled', 'Cash', 0.00, 5.00, 0.00, 5000.00, 0.000, 0.00, 5000.00, 'LKR', '', 2, '2025-10-17 05:25:09'),
(4, 'INV-202510-0002', 2, '2025-10-17', 'paid', 'Cash', 0.00, 3.00, 0.00, 2780.00, 0.000, 0.00, 2780.00, 'LKR', '', 1, '2025-10-17 08:15:12'),
(5, 'INV-SGY-202510-0001', 2, '2025-10-06', 'cancelled', 'Cash', 22500.00, 0.00, 0.00, 2000.00, 0.000, 0.00, 24500.00, 'LKR', '', 2, '2025-10-17 10:06:36');

-- --------------------------------------------------------

--
-- Table structure for table `invoice_approvals`
--

CREATE TABLE `invoice_approvals` (
  `id` int(11) NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `action` enum('cancel','amend') NOT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `requested_by` int(11) DEFAULT NULL,
  `approved_by` int(11) DEFAULT NULL,
  `used` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `decided_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `invoice_items`
--

CREATE TABLE `invoice_items` (
  `id` int(11) NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `final_product_id` int(11) DEFAULT NULL,
  `production_item_id` int(11) DEFAULT NULL,
  `cut_piece_id` int(11) DEFAULT NULL,
  `description` varchar(255) NOT NULL,
  `qty` decimal(12,3) NOT NULL DEFAULT 1.000,
  `returned_qty` decimal(12,3) NOT NULL DEFAULT 0.000,
  `unit_price` decimal(14,2) NOT NULL DEFAULT 0.00,
  `line_total` decimal(14,2) NOT NULL DEFAULT 0.00
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `invoice_items`
--

INSERT INTO `invoice_items` (`id`, `invoice_id`, `final_product_id`, `production_item_id`, `cut_piece_id`, `description`, `qty`, `returned_qty`, `unit_price`, `line_total`) VALUES
(6, 4, 8, NULL, NULL, 'Slab 2 (24.000x50.000) [SQFT]', 9.000, 9.000, 3500.00, 0.00),
(7, 4, 5, NULL, NULL, 'Slab 2 (23.000x47.000) [SQFT]', 7.000, 7.000, 2700.00, 0.00),
(8, 5, 8, NULL, NULL, 'Slab 2 (24.000x50.000) [SQFT]', 9.000, 0.000, 2500.00, 22500.00);

-- --------------------------------------------------------

--
-- Table structure for table `invoice_return_items`
--

CREATE TABLE `invoice_return_items` (
  `id` int(11) NOT NULL,
  `invoice_item_id` int(11) NOT NULL,
  `qty_returned` decimal(12,3) NOT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `invoice_return_items`
--

INSERT INTO `invoice_return_items` (`id`, `invoice_item_id`, `qty_returned`, `reason`, `created_at`) VALUES
(3, 6, 1.000, 'OT', '2025-10-17 09:54:22'),
(4, 6, 8.000, 'wasda', '2025-10-17 09:54:43'),
(5, 7, 7.000, '', '2025-10-17 09:55:07');

-- --------------------------------------------------------

--
-- Table structure for table `materials`
--

CREATE TABLE `materials` (
  `id` int(11) NOT NULL,
  `material_code` varchar(30) DEFAULT NULL,
  `name` varchar(150) NOT NULL,
  `type_id` int(11) DEFAULT NULL,
  `finish_id` int(11) DEFAULT NULL,
  `color_id` int(11) DEFAULT NULL,
  `length_mm` decimal(10,2) DEFAULT NULL,
  `width_mm` decimal(10,2) DEFAULT NULL,
  `thickness_mm` decimal(10,2) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `materials`
--

INSERT INTO `materials` (`id`, `material_code`, `name`, `type_id`, `finish_id`, `color_id`, `length_mm`, `width_mm`, `thickness_mm`, `notes`, `is_active`, `created_at`) VALUES
(2, 'MAT-202510-0001', 'Viscon', 4, 2, 3, 610.00, 2439.00, 10.00, '', 1, '2025-10-16 04:18:50'),
(3, 'MAT-202510-0002', 'Polishing Briks', NULL, NULL, NULL, NULL, NULL, NULL, '', 1, '2025-10-16 05:09:18');

-- --------------------------------------------------------

--
-- Table structure for table `payments`
--

CREATE TABLE `payments` (
  `id` int(11) NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `pay_date` date NOT NULL,
  `method` varchar(50) NOT NULL,
  `amount` decimal(14,2) NOT NULL,
  `reference_no` varchar(100) DEFAULT NULL,
  `notes` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `payments`
--

INSERT INTO `payments` (`id`, `invoice_id`, `pay_date`, `method`, `amount`, `reference_no`, `notes`, `created_at`) VALUES
(1, 4, '2025-10-17', 'Cash', 22000.00, 'Advance at create', 'Advance', '2025-10-17 08:15:12'),
(2, 4, '2025-10-17', 'Cash', 30692.00, 'eee', '', '2025-10-17 08:15:43'),
(4, 4, '2025-10-17', 'Cash', 2000.00, 'eee', 'Fial payment', '2025-10-17 08:35:15'),
(5, 4, '2025-10-17', 'Adjustment', -3605.00, 'Return adjustment', 'Auto adjustment for item return', '2025-10-17 09:54:22'),
(6, 4, '2025-10-17', 'Adjustment', -28840.00, 'Return adjustment', 'Auto adjustment for item return', '2025-10-17 09:54:43'),
(7, 4, '2025-10-17', 'Adjustment', -19467.00, 'Return adjustment', 'Auto adjustment for item return', '2025-10-17 09:55:07'),
(8, 5, '2025-10-17', 'Cash', 24500.00, '', '', '2025-10-17 10:07:29');

-- --------------------------------------------------------

--
-- Table structure for table `payment_terms`
--

CREATE TABLE `payment_terms` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `payment_terms`
--

INSERT INTO `payment_terms` (`id`, `name`, `created_at`) VALUES
(1, 'LC', '2025-10-07 14:06:07'),
(2, 'TT', '2025-10-07 14:06:18'),
(3, 'DA', '2025-10-07 14:06:35');

-- --------------------------------------------------------

--
-- Table structure for table `polishing_jobs`
--

CREATE TABLE `polishing_jobs` (
  `id` int(11) NOT NULL,
  `rmp_id` int(11) NOT NULL,
  `po_id` int(11) NOT NULL,
  `pre_height` decimal(12,3) DEFAULT NULL,
  `pre_length` decimal(12,3) DEFAULT NULL,
  `worker_name` varchar(150) DEFAULT NULL,
  `worker_id` int(11) DEFAULT NULL,
  `notes` varchar(255) DEFAULT NULL,
  `polishing_type` varchar(100) DEFAULT NULL,
  `rate_per_sqft` decimal(12,2) DEFAULT NULL,
  `direct_cost` decimal(12,2) DEFAULT NULL,
  `status` enum('pending','in_progress','completed','cancelled') NOT NULL DEFAULT 'in_progress',
  `start_at` datetime DEFAULT current_timestamp(),
  `end_at` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `polishing_jobs`
--

INSERT INTO `polishing_jobs` (`id`, `rmp_id`, `po_id`, `pre_height`, `pre_length`, `worker_name`, `worker_id`, `notes`, `polishing_type`, `rate_per_sqft`, `direct_cost`, `status`, `start_at`, `end_at`, `created_at`) VALUES
(4, 23, 2, 23.000, 48.000, 'shanaka', 1, '', NULL, NULL, NULL, 'completed', '2025-10-16 00:00:00', '2025-10-16 00:00:00', '2025-10-16 10:34:03'),
(5, 13, 2, 23.000, 47.000, 'shanaka', 1, '', NULL, NULL, NULL, 'completed', '2025-10-16 00:00:00', '2025-10-16 00:00:00', '2025-10-16 13:41:13'),
(6, 15, 2, 23.000, 47.000, 'shanaka', 1, '', NULL, NULL, NULL, 'completed', '2025-10-16 00:00:00', '2025-10-16 00:00:00', '2025-10-16 14:48:22'),
(7, 14, 2, 23.000, 47.000, 'shanaka', 1, '', NULL, NULL, NULL, 'completed', '2025-10-16 00:00:00', '2025-10-16 00:00:00', '2025-10-16 14:50:12'),
(8, 25, 2, 25.000, 49.000, 'shanaka', 1, '', NULL, NULL, NULL, 'completed', '2025-10-16 00:00:00', '2025-10-16 00:00:00', '2025-10-16 14:51:24'),
(9, 27, 2, 25.000, 47.000, 'shanaka', 1, '0', NULL, NULL, NULL, 'completed', '2025-10-17 00:00:00', '2025-10-17 00:00:00', '2025-10-17 04:56:50'),
(10, 22, 2, 23.000, 49.000, 'shanaka', 1, '', NULL, NULL, NULL, 'completed', '2025-10-17 00:00:00', '2025-10-17 00:00:00', '2025-10-17 05:01:27');

-- --------------------------------------------------------

--
-- Table structure for table `production_items`
--

CREATE TABLE `production_items` (
  `id` int(11) NOT NULL,
  `type_id` int(11) NOT NULL,
  `quality_id` int(11) DEFAULT NULL,
  `name` varchar(150) DEFAULT NULL,
  `color_id` int(11) DEFAULT NULL,
  `finish_id` int(11) DEFAULT NULL,
  `length` decimal(10,2) NOT NULL,
  `width` decimal(10,2) NOT NULL,
  `thickness` decimal(10,2) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 1,
  `availability` enum('available','reserved','sold') NOT NULL DEFAULT 'available',
  `notes` varchar(255) DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `production_items`
--

INSERT INTO `production_items` (`id`, `type_id`, `quality_id`, `name`, `color_id`, `finish_id`, `length`, `width`, `thickness`, `quantity`, `availability`, `notes`, `branch_id`, `created_at`, `updated_at`) VALUES
(2, 3, NULL, '2x2', 2, 4, 24.00, 24.00, 1.00, 25, 'available', '', 1, '2025-10-16 20:59:12', '2025-10-16 20:59:12'),
(3, 3, NULL, '2X1', 2, 4, 24.00, 12.00, 1.00, 10, 'available', '', 2, '2025-10-17 10:12:47', '2025-10-17 10:53:16'),
(4, 3, NULL, '1X1', 2, 4, 12.00, 12.00, 20.00, 10, 'available', '', 1, '2025-10-17 10:13:27', '2025-10-17 10:13:45');

-- --------------------------------------------------------

--
-- Table structure for table `production_qualities`
--

CREATE TABLE `production_qualities` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `production_types`
--

CREATE TABLE `production_types` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `product_types`
--

CREATE TABLE `product_types` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `product_types`
--

INSERT INTO `product_types` (`id`, `name`, `created_at`) VALUES
(3, 'Galaxy', '2025-10-07 14:13:37'),
(4, 'Viscon', '2025-10-07 14:13:46'),
(5, 'JET', '2025-10-07 14:13:56'),
(6, 'Rakwan Green', '2025-10-08 18:25:57');

-- --------------------------------------------------------

--
-- Table structure for table `purchase_orders`
--

CREATE TABLE `purchase_orders` (
  `id` int(11) NOT NULL,
  `order_no` varchar(50) NOT NULL,
  `supplier_id` int(11) NOT NULL,
  `order_date` date NOT NULL,
  `expected_date` date DEFAULT NULL,
  `confirmed_at` date DEFAULT NULL,
  `shipped_at` date DEFAULT NULL,
  `received_at` date DEFAULT NULL,
  `cancelled_at` date DEFAULT NULL,
  `status` enum('pending','confirmed','shipped','received','cancelled') NOT NULL DEFAULT 'pending',
  `ship_mode` varchar(50) DEFAULT NULL,
  `delivery_term` varchar(50) DEFAULT NULL,
  `payment_term` varchar(50) DEFAULT NULL,
  `supplier_contact` varchar(150) DEFAULT NULL,
  `supplier_email` varchar(150) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `total_amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `purchase_orders`
--

INSERT INTO `purchase_orders` (`id`, `order_no`, `supplier_id`, `order_date`, `expected_date`, `confirmed_at`, `shipped_at`, `received_at`, `cancelled_at`, `status`, `ship_mode`, `delivery_term`, `payment_term`, `supplier_contact`, `supplier_email`, `notes`, `total_amount`, `created_at`) VALUES
(2, 'PO-202510-0001', 1, '2025-10-16', '2025-10-16', '2025-10-16', '2025-10-16', '2025-10-16', NULL, 'received', '', '', '', 'shanaka', 'passdsandaruwan@gmail.com', '', 3666.00, '2025-10-16 06:14:19');

-- --------------------------------------------------------

--
-- Table structure for table `purchase_order_invoices`
--

CREATE TABLE `purchase_order_invoices` (
  `id` int(11) NOT NULL,
  `po_id` int(11) NOT NULL,
  `invoice_no` varchar(100) DEFAULT NULL,
  `invoice_date` date DEFAULT NULL,
  `amount` decimal(12,2) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `file_name` varchar(255) NOT NULL,
  `file_path` varchar(255) NOT NULL,
  `uploaded_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `purchase_order_items`
--

CREATE TABLE `purchase_order_items` (
  `id` int(11) NOT NULL,
  `po_id` int(11) NOT NULL,
  `line_no` int(11) NOT NULL,
  `description` text NOT NULL,
  `hs_code` varchar(50) DEFAULT NULL,
  `quantity` decimal(12,3) NOT NULL DEFAULT 0.000,
  `unit` varchar(20) DEFAULT NULL,
  `unit_price` decimal(12,3) NOT NULL DEFAULT 0.000,
  `line_total` decimal(12,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `note` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `purchase_order_items`
--

INSERT INTO `purchase_order_items` (`id`, `po_id`, `line_no`, `description`, `hs_code`, `quantity`, `unit`, `unit_price`, `line_total`, `created_at`, `note`) VALUES
(3, 2, 1, 'Viscon (MAT-202510-0001) - dfgdfgvc wd egf we', '', 180.000, '', 20.350, 3663.00, '2025-10-16 06:14:19', NULL),
(4, 2, 2, 'Polishing Briks (MAT-202510-0002) - sdfv dfwf', '', 6.000, '', 0.500, 3.00, '2025-10-16 06:14:19', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `raw_material_products`
--

CREATE TABLE `raw_material_products` (
  `id` int(11) NOT NULL,
  `po_id` int(11) NOT NULL,
  `product_type_id` int(11) DEFAULT NULL,
  `slab_no` varchar(50) DEFAULT NULL,
  `height` decimal(12,3) DEFAULT NULL,
  `length` decimal(12,3) DEFAULT NULL,
  `sq_ft` decimal(12,3) DEFAULT NULL,
  `sq_m2` decimal(12,3) DEFAULT NULL,
  `quality` varchar(50) DEFAULT NULL,
  `price` decimal(12,3) DEFAULT NULL,
  `value` decimal(12,3) DEFAULT NULL,
  `length_remark` varchar(100) DEFAULT NULL,
  `status` enum('received','in_polishing','polished','finished','sold') NOT NULL DEFAULT 'received',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `raw_material_products`
--

INSERT INTO `raw_material_products` (`id`, `po_id`, `product_type_id`, `slab_no`, `height`, `length`, `sq_ft`, `sq_m2`, `quality`, `price`, `value`, `length_remark`, `status`, `created_at`) VALUES
(13, 2, 5, '1', 23.000, 47.000, 7.507, 0.697, 'Premium', 16.000, 11.150, 'Shorter', 'finished', '2025-10-16 08:30:10'),
(14, 2, 3, '2', 23.000, 47.000, 7.507, 0.697, 'Premium', 16.000, 11.159, 'Shorter', 'finished', '2025-10-16 08:30:10'),
(15, 2, 3, '3', 23.000, 47.000, 7.507, 0.697, 'Premium', 16.000, 11.159, 'Shorter', 'finished', '2025-10-16 08:30:10'),
(16, 2, 3, '4', 24.000, 48.000, 8.000, 0.743, 'Premium', 16.000, 11.891, 'Shorter', 'received', '2025-10-16 08:30:10'),
(17, 2, 3, '5', 25.000, 49.000, 8.507, 0.790, 'Premium', 16.000, 12.645, 'Shorter', 'received', '2025-10-16 08:30:10'),
(18, 2, 3, '6', 25.000, 49.000, 8.507, 0.790, 'Premium', 16.000, 12.645, 'Shorter', 'received', '2025-10-16 08:30:10'),
(19, 2, 3, '7', 25.000, 47.000, 8.160, 0.758, 'Premium', 16.000, 12.129, 'Shorter', 'received', '2025-10-16 08:30:10'),
(20, 2, 3, '8', 24.000, 47.000, 7.833, 0.728, 'Premium', 16.000, 11.644, 'Shorter', 'received', '2025-10-16 08:30:10'),
(21, 2, 3, '1', 23.000, 47.000, 7.507, 0.697, 'Premium', 16.000, 11.150, 'Shorter', 'finished', '2025-10-16 08:35:43'),
(22, 2, 5, '2', 23.000, 49.000, 7.826, 0.727, 'Premium', 16.000, 11.160, 'Shorter', 'finished', '2025-10-16 08:35:43'),
(23, 2, 5, '3', 23.000, 47.000, 7.507, 0.697, 'Premium', 16.000, 11.159, 'Shorter', 'finished', '2025-10-16 08:35:44'),
(24, 2, 5, '4', 24.000, 48.000, 8.000, 0.743, 'Premium', 16.000, 11.891, 'Shorter', 'received', '2025-10-16 08:35:44'),
(25, 2, 5, '5', 25.000, 49.000, 8.507, 0.790, 'Premium', 16.000, 12.645, 'Shorter', 'finished', '2025-10-16 08:35:44'),
(26, 2, 5, '6', 25.000, 49.000, 8.507, 0.790, 'Premium', 16.000, 12.645, 'Shorter', 'received', '2025-10-16 08:35:44'),
(27, 2, 5, '7', 25.000, 47.000, 8.160, 0.758, 'Premium', 16.000, 12.129, 'Shorter', 'finished', '2025-10-16 08:35:44'),
(28, 2, 5, '8', 24.000, 47.000, 7.833, 0.728, 'Premium', 16.000, 11.644, 'Shorter', 'received', '2025-10-16 08:35:44');

-- --------------------------------------------------------

--
-- Table structure for table `salary_advances`
--

CREATE TABLE `salary_advances` (
  `id` int(11) NOT NULL,
  `employee_id` int(11) NOT NULL,
  `adv_date` date NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `notes` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `salary_allowances`
--

CREATE TABLE `salary_allowances` (
  `id` int(11) NOT NULL,
  `employee_id` int(11) NOT NULL,
  `all_date` date NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `salary_deductions`
--

CREATE TABLE `salary_deductions` (
  `id` int(11) NOT NULL,
  `employee_id` int(11) NOT NULL,
  `ded_date` date NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `salary_incentives`
--

CREATE TABLE `salary_incentives` (
  `id` int(11) NOT NULL,
  `employee_id` int(11) NOT NULL,
  `inc_date` date NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `salary_payroll`
--

CREATE TABLE `salary_payroll` (
  `id` int(11) NOT NULL,
  `employee_id` int(11) NOT NULL,
  `period_month` tinyint(4) NOT NULL,
  `period_year` smallint(6) NOT NULL,
  `gross_salary` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_incentives` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_allowances` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_advances` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_deductions` decimal(12,2) NOT NULL DEFAULT 0.00,
  `net_salary` decimal(12,2) NOT NULL DEFAULT 0.00,
  `paid_on` date DEFAULT NULL,
  `notes` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `salary_payroll`
--

INSERT INTO `salary_payroll` (`id`, `employee_id`, `period_month`, `period_year`, `gross_salary`, `total_incentives`, `total_allowances`, `total_advances`, `total_deductions`, `net_salary`, `paid_on`, `notes`, `created_at`) VALUES
(1, 1, 10, 2025, 46000.00, 0.00, 0.00, 0.00, 0.00, 46000.00, NULL, NULL, '2025-10-17 18:44:20');

-- --------------------------------------------------------

--
-- Table structure for table `ship_modes`
--

CREATE TABLE `ship_modes` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `shop_settings`
--

CREATE TABLE `shop_settings` (
  `id` int(11) NOT NULL,
  `company_name` varchar(150) NOT NULL DEFAULT 'Granite Warehouse',
  `address_line` varchar(255) NOT NULL DEFAULT 'Warehouse Address Line',
  `city_country` varchar(150) NOT NULL DEFAULT 'City, Country',
  `company_email` varchar(150) NOT NULL DEFAULT '',
  `phone` varchar(50) NOT NULL DEFAULT '-',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `shop_settings`
--

INSERT INTO `shop_settings` (`id`, `company_name`, `address_line`, `city_country`, `company_email`, `phone`, `updated_at`) VALUES
(1, 'SW Granite', '32(586/F)', 'Kalawana', 'passdsandaruwan@gmail.com', '0712270145', '2025-10-08 13:35:38');

-- --------------------------------------------------------

--
-- Table structure for table `store_locations`
--

CREATE TABLE `store_locations` (
  `id` int(11) NOT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `name` varchar(150) NOT NULL,
  `notes` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `store_locations`
--

INSERT INTO `store_locations` (`id`, `branch_id`, `name`, `notes`, `is_active`, `created_at`) VALUES
(1, NULL, 'Cut Slab Warehouse', '', 1, '2025-10-16 10:10:08'),
(2, 2, 'Yakkala A', '', 1, '2025-10-16 15:27:05'),
(3, 2, 'Yakkala B', '', 1, '2025-10-16 17:09:47'),
(4, 1, 'Kandy A', '', 1, '2025-10-16 17:09:57');

-- --------------------------------------------------------

--
-- Table structure for table `suppliers`
--

CREATE TABLE `suppliers` (
  `id` int(11) NOT NULL,
  `supplier_code` varchar(30) DEFAULT NULL,
  `name` varchar(150) NOT NULL,
  `contact_person` varchar(150) DEFAULT NULL,
  `email` varchar(150) DEFAULT NULL,
  `contact` varchar(150) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `tax_id` varchar(30) DEFAULT NULL,
  `payment_terms` varchar(50) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `suppliers`
--

INSERT INTO `suppliers` (`id`, `supplier_code`, `name`, `contact_person`, `email`, `contact`, `phone`, `address`, `country`, `tax_id`, `payment_terms`, `currency`, `is_active`, `created_at`) VALUES
(1, 'SUP-202510-0001', 'IIT India', 'shanaka', 'passdsandaruwan@gmail.com', NULL, '0712270145', '32(586/F)\r\nThapassarakanda South', 'Sri Lanka', 'GST456', 'Net 15', 'USD', 1, '2025-10-16 04:19:24');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `username` varchar(100) NOT NULL,
  `full_name` varchar(150) DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `role` enum('super_admin','admin','sales_user') NOT NULL DEFAULT 'sales_user',
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `password_hash` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `username`, `full_name`, `branch_id`, `role`, `is_active`, `password_hash`, `created_at`) VALUES
(1, 'superadmin', 'Super Admin', NULL, 'super_admin', 1, '$2y$10$DTU3E4IvWyn9z8ymTrraWuoEiN/nhLlGsUDvvzmOUv6PWKDjWliA2', '2025-10-07 09:58:41'),
(4, 'yakkala', 'yakkala', 2, 'sales_user', 1, '$2y$10$Sfd/qwKGu899WVn3lf.i/OJlp8ZyGKtsOqqrV9nSgLLsnGP2Vdyoy', '2025-10-17 04:33:54');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `branches`
--
ALTER TABLE `branches`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `colors`
--
ALTER TABLE `colors`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `customers`
--
ALTER TABLE `customers`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_customers_branch` (`branch_id`);

--
-- Indexes for table `cutting_jobs`
--
ALTER TABLE `cutting_jobs`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `cut_pieces`
--
ALTER TABLE `cut_pieces`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_cut_job` (`job_id`),
  ADD KEY `idx_cut_pieces_branch` (`branch_id`);

--
-- Indexes for table `delivery_terms`
--
ALTER TABLE `delivery_terms`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `designations`
--
ALTER TABLE `designations`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `employees`
--
ALTER TABLE `employees`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `emp_code` (`emp_code`),
  ADD KEY `fk_emp_branch` (`branch_id`),
  ADD KEY `fk_emp_designation` (`designation_id`);

--
-- Indexes for table `expenditures`
--
ALTER TABLE `expenditures`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_expenditures_category` (`category_id`),
  ADD KEY `idx_expenditures_branch` (`branch_id`);

--
-- Indexes for table `expenditure_categories`
--
ALTER TABLE `expenditure_categories`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `final_products`
--
ALTER TABLE `final_products`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_final_rmp` (`rmp_id`),
  ADD KEY `fk_final_po` (`po_id`),
  ADD KEY `fk_final_polish` (`polishing_job_id`),
  ADD KEY `fk_final_finish` (`finish_id`),
  ADD KEY `fk_final_branch` (`branch_id`),
  ADD KEY `fk_final_store` (`store_location_id`),
  ADD KEY `fk_final_type` (`type_id`),
  ADD KEY `fk_final_color` (`color_id`);

--
-- Indexes for table `finishes`
--
ALTER TABLE `finishes`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `imports`
--
ALTER TABLE `imports`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_import_po` (`po_id`);

--
-- Indexes for table `import_items`
--
ALTER TABLE `import_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_import_item_import` (`import_id`),
  ADD KEY `fk_import_item_po_item` (`po_item_id`);

--
-- Indexes for table `inventory_moves`
--
ALTER TABLE `inventory_moves`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `invoices`
--
ALTER TABLE `invoices`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `invoice_no` (`invoice_no`),
  ADD KEY `fk_inv_cust` (`customer_id`);

--
-- Indexes for table `invoice_approvals`
--
ALTER TABLE `invoice_approvals`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_inv_appr_inv` (`invoice_id`);

--
-- Indexes for table `invoice_items`
--
ALTER TABLE `invoice_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_inv_item_inv` (`invoice_id`),
  ADD KEY `fk_inv_item_fp` (`final_product_id`);

--
-- Indexes for table `invoice_return_items`
--
ALTER TABLE `invoice_return_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_inv_ret_item` (`invoice_item_id`);

--
-- Indexes for table `materials`
--
ALTER TABLE `materials`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `material_code` (`material_code`),
  ADD KEY `fk_material_type` (`type_id`),
  ADD KEY `fk_material_finish` (`finish_id`),
  ADD KEY `fk_material_color` (`color_id`);

--
-- Indexes for table `payments`
--
ALTER TABLE `payments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_pay_inv` (`invoice_id`);

--
-- Indexes for table `payment_terms`
--
ALTER TABLE `payment_terms`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `polishing_jobs`
--
ALTER TABLE `polishing_jobs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_polish_rmp` (`rmp_id`),
  ADD KEY `fk_polish_po` (`po_id`);

--
-- Indexes for table `production_items`
--
ALTER TABLE `production_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_prod_item_quality` (`quality_id`),
  ADD KEY `fk_prod_item_color` (`color_id`),
  ADD KEY `fk_prod_item_finish` (`finish_id`),
  ADD KEY `fk_pi_type` (`type_id`);

--
-- Indexes for table `production_qualities`
--
ALTER TABLE `production_qualities`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `production_types`
--
ALTER TABLE `production_types`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `product_types`
--
ALTER TABLE `product_types`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `purchase_orders`
--
ALTER TABLE `purchase_orders`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `order_no` (`order_no`),
  ADD KEY `fk_po_supplier` (`supplier_id`);

--
-- Indexes for table `purchase_order_invoices`
--
ALTER TABLE `purchase_order_invoices`
  ADD PRIMARY KEY (`id`),
  ADD KEY `po_id` (`po_id`);

--
-- Indexes for table `purchase_order_items`
--
ALTER TABLE `purchase_order_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_poi_po` (`po_id`);

--
-- Indexes for table `raw_material_products`
--
ALTER TABLE `raw_material_products`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_rmp_po` (`po_id`),
  ADD KEY `fk_rmp_type` (`product_type_id`);

--
-- Indexes for table `salary_advances`
--
ALTER TABLE `salary_advances`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_salary_adv_emp` (`employee_id`);

--
-- Indexes for table `salary_allowances`
--
ALTER TABLE `salary_allowances`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_salary_all_emp` (`employee_id`);

--
-- Indexes for table `salary_deductions`
--
ALTER TABLE `salary_deductions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_salary_ded_emp` (`employee_id`);

--
-- Indexes for table `salary_incentives`
--
ALTER TABLE `salary_incentives`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_salary_inc_emp` (`employee_id`);

--
-- Indexes for table `salary_payroll`
--
ALTER TABLE `salary_payroll`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_emp_month` (`employee_id`,`period_month`,`period_year`);

--
-- Indexes for table `ship_modes`
--
ALTER TABLE `ship_modes`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `shop_settings`
--
ALTER TABLE `shop_settings`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `store_locations`
--
ALTER TABLE `store_locations`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`),
  ADD KEY `fk_store_branch` (`branch_id`);

--
-- Indexes for table `suppliers`
--
ALTER TABLE `suppliers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `supplier_code` (`supplier_code`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `branches`
--
ALTER TABLE `branches`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `colors`
--
ALTER TABLE `colors`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `customers`
--
ALTER TABLE `customers`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `cutting_jobs`
--
ALTER TABLE `cutting_jobs`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `cut_pieces`
--
ALTER TABLE `cut_pieces`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `delivery_terms`
--
ALTER TABLE `delivery_terms`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `designations`
--
ALTER TABLE `designations`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `employees`
--
ALTER TABLE `employees`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `expenditures`
--
ALTER TABLE `expenditures`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `expenditure_categories`
--
ALTER TABLE `expenditure_categories`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=20;

--
-- AUTO_INCREMENT for table `final_products`
--
ALTER TABLE `final_products`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `finishes`
--
ALTER TABLE `finishes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `imports`
--
ALTER TABLE `imports`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `import_items`
--
ALTER TABLE `import_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `inventory_moves`
--
ALTER TABLE `inventory_moves`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `invoices`
--
ALTER TABLE `invoices`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `invoice_approvals`
--
ALTER TABLE `invoice_approvals`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `invoice_items`
--
ALTER TABLE `invoice_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `invoice_return_items`
--
ALTER TABLE `invoice_return_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `materials`
--
ALTER TABLE `materials`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `payments`
--
ALTER TABLE `payments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `payment_terms`
--
ALTER TABLE `payment_terms`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `polishing_jobs`
--
ALTER TABLE `polishing_jobs`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `production_items`
--
ALTER TABLE `production_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `production_qualities`
--
ALTER TABLE `production_qualities`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `production_types`
--
ALTER TABLE `production_types`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `product_types`
--
ALTER TABLE `product_types`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `purchase_orders`
--
ALTER TABLE `purchase_orders`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `purchase_order_invoices`
--
ALTER TABLE `purchase_order_invoices`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `purchase_order_items`
--
ALTER TABLE `purchase_order_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `raw_material_products`
--
ALTER TABLE `raw_material_products`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=29;

--
-- AUTO_INCREMENT for table `salary_advances`
--
ALTER TABLE `salary_advances`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `salary_allowances`
--
ALTER TABLE `salary_allowances`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `salary_deductions`
--
ALTER TABLE `salary_deductions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `salary_incentives`
--
ALTER TABLE `salary_incentives`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `salary_payroll`
--
ALTER TABLE `salary_payroll`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `ship_modes`
--
ALTER TABLE `ship_modes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `shop_settings`
--
ALTER TABLE `shop_settings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `store_locations`
--
ALTER TABLE `store_locations`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `suppliers`
--
ALTER TABLE `suppliers`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `cut_pieces`
--
ALTER TABLE `cut_pieces`
  ADD CONSTRAINT `fk_cut_job` FOREIGN KEY (`job_id`) REFERENCES `cutting_jobs` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `employees`
--
ALTER TABLE `employees`
  ADD CONSTRAINT `fk_emp_branch` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_emp_designation` FOREIGN KEY (`designation_id`) REFERENCES `designations` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `expenditures`
--
ALTER TABLE `expenditures`
  ADD CONSTRAINT `fk_expenditures_branch` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_expenditures_category` FOREIGN KEY (`category_id`) REFERENCES `expenditure_categories` (`id`);

--
-- Constraints for table `final_products`
--
ALTER TABLE `final_products`
  ADD CONSTRAINT `fk_final_branch` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_final_color` FOREIGN KEY (`color_id`) REFERENCES `colors` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_final_finish` FOREIGN KEY (`finish_id`) REFERENCES `finishes` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_final_po` FOREIGN KEY (`po_id`) REFERENCES `purchase_orders` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_final_polish` FOREIGN KEY (`polishing_job_id`) REFERENCES `polishing_jobs` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_final_rmp` FOREIGN KEY (`rmp_id`) REFERENCES `raw_material_products` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_final_store` FOREIGN KEY (`store_location_id`) REFERENCES `store_locations` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_final_type` FOREIGN KEY (`type_id`) REFERENCES `product_types` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `imports`
--
ALTER TABLE `imports`
  ADD CONSTRAINT `fk_import_po` FOREIGN KEY (`po_id`) REFERENCES `purchase_orders` (`id`);

--
-- Constraints for table `import_items`
--
ALTER TABLE `import_items`
  ADD CONSTRAINT `fk_import_item_import` FOREIGN KEY (`import_id`) REFERENCES `imports` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_import_item_po_item` FOREIGN KEY (`po_item_id`) REFERENCES `purchase_order_items` (`id`);

--
-- Constraints for table `invoices`
--
ALTER TABLE `invoices`
  ADD CONSTRAINT `fk_inv_cust` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`);

--
-- Constraints for table `invoice_approvals`
--
ALTER TABLE `invoice_approvals`
  ADD CONSTRAINT `fk_inv_appr_inv` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `invoice_items`
--
ALTER TABLE `invoice_items`
  ADD CONSTRAINT `fk_inv_item_fp` FOREIGN KEY (`final_product_id`) REFERENCES `final_products` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_inv_item_inv` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `invoice_return_items`
--
ALTER TABLE `invoice_return_items`
  ADD CONSTRAINT `fk_inv_ret_item` FOREIGN KEY (`invoice_item_id`) REFERENCES `invoice_items` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `materials`
--
ALTER TABLE `materials`
  ADD CONSTRAINT `fk_material_color` FOREIGN KEY (`color_id`) REFERENCES `colors` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_material_finish` FOREIGN KEY (`finish_id`) REFERENCES `finishes` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_material_type` FOREIGN KEY (`type_id`) REFERENCES `product_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `payments`
--
ALTER TABLE `payments`
  ADD CONSTRAINT `fk_pay_inv` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `polishing_jobs`
--
ALTER TABLE `polishing_jobs`
  ADD CONSTRAINT `fk_polish_po` FOREIGN KEY (`po_id`) REFERENCES `purchase_orders` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_polish_rmp` FOREIGN KEY (`rmp_id`) REFERENCES `raw_material_products` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `production_items`
--
ALTER TABLE `production_items`
  ADD CONSTRAINT `fk_pi_type` FOREIGN KEY (`type_id`) REFERENCES `product_types` (`id`),
  ADD CONSTRAINT `fk_prod_item_color` FOREIGN KEY (`color_id`) REFERENCES `colors` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_prod_item_finish` FOREIGN KEY (`finish_id`) REFERENCES `finishes` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_prod_item_quality` FOREIGN KEY (`quality_id`) REFERENCES `production_qualities` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_prod_item_type` FOREIGN KEY (`type_id`) REFERENCES `product_types` (`id`);

--
-- Constraints for table `purchase_orders`
--
ALTER TABLE `purchase_orders`
  ADD CONSTRAINT `fk_po_supplier` FOREIGN KEY (`supplier_id`) REFERENCES `suppliers` (`id`) ON UPDATE CASCADE;

--
-- Constraints for table `purchase_order_invoices`
--
ALTER TABLE `purchase_order_invoices`
  ADD CONSTRAINT `purchase_order_invoices_ibfk_1` FOREIGN KEY (`po_id`) REFERENCES `purchase_orders` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `purchase_order_items`
--
ALTER TABLE `purchase_order_items`
  ADD CONSTRAINT `fk_poi_po` FOREIGN KEY (`po_id`) REFERENCES `purchase_orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `raw_material_products`
--
ALTER TABLE `raw_material_products`
  ADD CONSTRAINT `fk_rmp_po` FOREIGN KEY (`po_id`) REFERENCES `purchase_orders` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_rmp_type` FOREIGN KEY (`product_type_id`) REFERENCES `product_types` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `salary_advances`
--
ALTER TABLE `salary_advances`
  ADD CONSTRAINT `fk_salary_adv_emp` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `salary_allowances`
--
ALTER TABLE `salary_allowances`
  ADD CONSTRAINT `fk_salary_all_emp` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `salary_deductions`
--
ALTER TABLE `salary_deductions`
  ADD CONSTRAINT `fk_salary_ded_emp` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `salary_incentives`
--
ALTER TABLE `salary_incentives`
  ADD CONSTRAINT `fk_salary_inc_emp` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `salary_payroll`
--
ALTER TABLE `salary_payroll`
  ADD CONSTRAINT `fk_payroll_emp` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `store_locations`
--
ALTER TABLE `store_locations`
  ADD CONSTRAINT `fk_store_branch` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE SET NULL;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
