<?php require_once __DIR__ . '/../includes/auth.php'; require_login(); ?>
<div class="page-cutting_inventory">
  <div class="container-fluid p-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
      <h4>Cutting Slab Inventory</h4>
      <div class="d-flex gap-2">
        <button class="btn btn-outline-secondary" id="btnRefreshCutInv"><i class="bi bi-arrow-clockwise"></i></button>
      </div>
    </div>

    <div class="card shadow-sm mb-3">
      <div class="card-body">
        <div class="row g-2 align-items-end">
          <div class="col-md-3">
            <label class="form-label">Search</label>
            <input type="text" id="ci_q" class="form-control" placeholder="ID / Job ID">
          </div>
          <div class="col-md-3">
            <label class="form-label">Status</label>
            <select id="ci_status" class="form-select">
              <option value="">All</option>
              <option value="usable">Usable</option>
              <option value="unusable">Unusable</option>
            </select>
          </div>
          <div class="col-md-3">
            <label class="form-label">Availability</label>
            <select id="ci_avail" class="form-select">
              <option value="">All</option>
              <option value="available">Available</option>
              <option value="reserved">Reserved</option>
              <option value="consumed">Consumed</option>
            </select>
          </div>
          <div class="col-md-3">
            <label class="form-label">Location</label>
            <select id="ci_loc" class="form-select"></select>
          </div>
        </div>
        <div class="row g-2 align-items-end mt-2">
          <div class="col-md-3">
            <label class="form-label">Slab No</label>
            <input type="text" id="ci_slab" class="form-control" placeholder="Search slab no">
          </div>
          <div class="col-md-3">
            <label class="form-label">Length (mm)</label>
            <div class="input-group">
              <input type="number" id="ci_len_min" class="form-control" placeholder="Min">
              <span class="input-group-text">-</span>
              <input type="number" id="ci_len_max" class="form-control" placeholder="Max">
            </div>
          </div>
          <div class="col-md-3">
            <label class="form-label">Width (mm)</label>
            <div class="input-group">
              <input type="number" id="ci_wid_min" class="form-control" placeholder="Min">
              <span class="input-group-text">-</span>
              <input type="number" id="ci_wid_max" class="form-control" placeholder="Max">
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="card shadow-sm">
      <div class="card-body">
        <div class="table-responsive">
          <table class="table table-sm align-middle" id="ci_table">
            <thead>
              <tr>
                <th>ID</th>
                <th>Slab No</th>
                <th>Job</th>
                <th>Piece</th>
                <th>Length (mm)</th>
                <th>Width (mm)</th>
                <th>Thick (mm)</th>
                <th>Area (sqft)</th>
                <th>Branch</th>
                <th>Status</th>
                <th>Avail</th>
                <th>Location</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody></tbody>
          </table>
        </div>
      </div>
    </div>

    <!-- Detail Modal -->
    <div class="modal fade" id="ciDetailModal" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog modal-sm modal-dialog-centered">
        <div class="modal-content">
          <div class="modal-header"><h6 class="modal-title">Cut Piece Detail</h6>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <div class="mb-1"><small class="text-muted">ID</small><div id="ci_d_id"></div></div>
            <div class="mb-1"><small class="text-muted">Slab No</small><div id="ci_d_slab"></div></div>
            <div class="mb-1"><small class="text-muted">Job</small><div id="ci_d_job"></div></div>
            <div class="mb-1"><small class="text-muted">Size (mm)</small><div id="ci_d_size"></div></div>
            <div class="mb-1"><small class="text-muted">Area (sqft)</small><div id="ci_d_area"></div></div>
            <div class="mb-1"><small class="text-muted">Status</small><div id="ci_d_status"></div></div>
            <div class="mb-1"><small class="text-muted">Location</small><div id="ci_d_loc"></div></div>
          </div>
          <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button></div>
        </div>
      </div>
    </div>

    <input type="hidden" id="csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>" />
  </div>
</div>

<script>
(function(){
  if (!$('.page-cutting_inventory').length) return;
  const CAN_EDIT = <?php echo has_role(['admin','super_admin']) ? 'true' : 'false'; ?>;
  const $tbl = $('#ci_table tbody');
  const $csrf = $('#csrf');
  let BRANCHES = [];

  function loadBranches(){
    $.get('api/branches.php', { action:'list' }, function(res){
      BRANCHES = (res.data||[]).filter(b=>parseInt(b.is_active));
    });
  }

  function loadLocations(){
    $.get('api/cut_pieces.php', { action:'locations' }, function(res){
      const opts=['<option value="">All</option>'];
      (res.data||[]).forEach(l=>opts.push(`<option value="${l.id}">${$('<div>').text(l.name||'').html()}</option>`));
      $('#ci_loc').html(opts.join(''));
    });
  }

  function renderBranchCell(row){
    const currentId = row.branch_id || '';
    if (!CAN_EDIT){
      const found = BRANCHES.find(b=>String(b.id)===String(currentId));
      return $('<td>').text(found? (found.name||('Branch #'+found.id)) : '');
    }
    const sel = $('<select class="form-select form-select-sm ci-branch">');
    sel.append('<option value="">Select</option>');
    BRANCHES.forEach(b=> sel.append(`<option value="${b.id}">${$('<div>').text(b.name||'').html()}</option>`));
    sel.val(String(currentId||''));
    sel.data('id', row.id);
    return $('<td>').append(sel);
  }

  function query(){
    const params = {
      action:'list',
      q: $('#ci_q').val(),
      status: $('#ci_status').val(),
      avail: $('#ci_avail').val(),
      location_id: $('#ci_loc').val(),
      slab_q: $('#ci_slab').val(),
      len_min: $('#ci_len_min').val(), len_max: $('#ci_len_max').val(),
      wid_min: $('#ci_wid_min').val(), wid_max: $('#ci_wid_max').val()
    };
    $.get('api/cut_pieces.php', params, function(res){
      $tbl.empty(); const rows = res.data||[];
      if (!rows.length){ $tbl.append('<tr><td colspan="13" class="text-center text-muted">No pieces found</td></tr>'); return; }
      rows.forEach(r=>{
        const tr = $('<tr>');
        tr.append(`<td>${r.id}</td>`);
        tr.append(`<td>${$('<div>').text(r.slab_no||'').html()}</td>`);
        tr.append(`<td>${r.job_id??''}</td>`);
        tr.append(`<td>${r.piece_no??''}</td>`);
        tr.append(`<td>${Math.round(r.length_mm||0)}</td>`);
        tr.append(`<td>${Math.round(r.width_mm||0)}</td>`);
        tr.append(`<td>${r.thickness_mm??''}</td>`);
        tr.append(`<td>${Number(r.area_sq_ft||0).toFixed(3)}</td>`);
        tr.append(renderBranchCell(r));
        tr.append(`<td>${$('<div>').text(r.status||'').html()}</td>`);
        tr.append(`<td>${parseInt(r.is_available)?'<span class="badge bg-success">Yes</span>':'<span class="badge bg-secondary">No</span>'}</td>`);
        tr.append(`<td>${$('<div>').text(r.location_name||'').html()}</td>`);
        tr.append(`<td><button class="btn btn-sm btn-outline-secondary ci-view" data-id="${r.id}"><i class="bi bi-eye"></i></button></td>`);
        $tbl.append(tr);
      });
    }).fail(xhr=> alert((xhr.responseJSON && xhr.responseJSON.message) || xhr.responseText || 'Error loading pieces'));
  }

  // Change branch inline (admin only)
  $(document).on('change', 'select.ci-branch', function(){
    if (!CAN_EDIT) return;
    const id = $(this).data('id');
    const branch_id = $(this).val();
    const fd = new FormData();
    fd.append('csrf', $csrf.val());
    fd.append('action','update');
    fd.append('id', id);
    fd.append('branch_id', branch_id);
    $.ajax({ url:'api/cut_pieces.php', method:'POST', data:fd, contentType:false, processData:false })
      .done(()=>{ window.showToast && window.showToast('Branch updated','success'); })
      .fail(xhr=> alert((xhr.responseJSON && xhr.responseJSON.message) || 'Update failed'));
  });

  // View detail
  $(document).on('click', '.ci-view', function(){
    const id=$(this).data('id');
    $.get('api/cut_pieces.php', { action:'get', id }, function(res){
      const d=res.data||{};
      $('#ci_d_id').text(d.id||'');
      $('#ci_d_slab').text(d.slab_no||'');
      $('#ci_d_job').text(d.job_id||'');
      const size = [Math.round(d.length_mm||0), Math.round(d.width_mm||0), Math.round(d.thickness_mm||0)].join(' x ');
      $('#ci_d_size').text(size);
      $('#ci_d_area').text(Number(d.area_sq_ft||0).toFixed(3));
      $('#ci_d_status').text(d.status||'');
      $('#ci_d_loc').text(d.location_name||'');
      $('#ciDetailModal').modal('show');
    });
  });

  // Bind filter actions
  $('#btnRefreshCutInv').on('click', query);
  $('#ci_q, #ci_slab, #ci_len_min, #ci_len_max, #ci_wid_min, #ci_wid_max').on('keydown', function(e){ if(e.key==='Enter') query(); });
  $('#ci_status, #ci_avail, #ci_loc').on('change', query);

  loadBranches(); loadLocations(); query();
})();
</script>
