<?php require_once __DIR__ . '/../includes/auth.php'; require_login(); ?>
<div class="page-finished-products">
  <div class="container-fluid p-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
      <h4>Finished Products</h4>
      <div>
        <button id="btnNewFP" class="btn btn-primary d-none"><i class="bi bi-plus-lg"></i></button>
      </div>
    </div>

    <div class="card shadow-sm mb-3"><div class="card-body">
      <div class="row g-2 align-items-end">
        <div class="col-md-2"><label class="form-label">Min H</label><input type="number" step="0.001" id="fltMinH" class="form-control"></div>
        <div class="col-md-2"><label class="form-label">Max H</label><input type="number" step="0.001" id="fltMaxH" class="form-control"></div>
        <div class="col-md-2"><label class="form-label">Min L</label><input type="number" step="0.001" id="fltMinL" class="form-control"></div>
        <div class="col-md-2"><label class="form-label">Max L</label><input type="number" step="0.001" id="fltMaxL" class="form-control"></div>
        <div class="col-md-2"><label class="form-label">Min Sq.Ft</label><input type="number" step="0.001" id="fltMinSqf" class="form-control"></div>
        <div class="col-md-2"><label class="form-label">Max Sq.Ft</label><input type="number" step="0.001" id="fltMaxSqf" class="form-control"></div>
        <div class="col-md-2"><label class="form-label">Type</label><select id="fltType" class="form-select"></select></div>
        <div class="col-md-2"><label class="form-label">Color</label><select id="fltColor" class="form-select"></select></div>
        <div class="col-md-3"><label class="form-label">Branch</label><select id="fltBranch" class="form-select"></select></div>
        <div class="col-md-3"><label class="form-label">Store</label><select id="fltStore" class="form-select"></select></div>
        <div class="col-md-2"><button id="btnSearch" class="btn btn-outline-secondary w-100"><i class="bi bi-search"></i></button></div>
      </div>
    </div></div>

    <div class="card shadow-sm"><div class="card-body">
      <div class="table-responsive">
        <table id="fpList" class="table table-hover align-middle">
          <thead>
            <tr>
              <th>Slab</th><th>Finish</th><th>Pre H</th><th>Pre L</th><th>Pre Sq.Ft</th><th>H</th><th>L</th><th>Sq.Ft</th><th>Type</th><th>Color</th><th>Branch</th><th>Store</th><th>Completed</th><th>Status</th><th>Actions</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div></div>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="fpEditModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Edit Finished Product</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form id="fpEditForm">
        <div class="modal-body">
          <input type="hidden" name="csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
          <input type="hidden" name="id" id="fp_id">
          <div class="row g-2">
            <div class="col-6"><label class="form-label">H</label><input type="number" step="0.001" class="form-control" name="final_height" id="fp_h"></div>
            <div class="col-6"><label class="form-label">L</label><input type="number" step="0.001" class="form-control" name="final_length" id="fp_l"></div>
            <div class="col-6"><label class="form-label">Sq.Ft</label><input type="number" step="0.001" class="form-control" name="final_sq_ft" id="fp_sqf"></div>
            <div class="col-6"><label class="form-label">Finish</label><select class="form-select" name="finish_id" id="fp_finish"></select></div>
            <div class="col-6"><label class="form-label">Type</label><select class="form-select" name="type_id" id="fp_type"></select></div>
            <div class="col-6"><label class="form-label">Color</label><select class="form-select" name="color_id" id="fp_color"></select></div>
            <div class="col-6"><label class="form-label">Branch</label><select class="form-select" name="branch_id" id="fp_branch"></select></div>
            <div class="col-6"><label class="form-label">Store</label><select class="form-select" name="store_location_id" id="fp_store"></select></div>
            <div class="col-12"><label class="form-label">Quality</label><input type="text" class="form-control" name="quality" id="fp_quality"></div>
            <div class="col-12"><label class="form-label">Status</label><select class="form-select" name="sale_status" id="fp_status"><option value="available">Available</option><option value="reserved">Reserved</option><option value="sold">Sold</option></select></div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary">Save</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- View Modal -->
<div class="modal fade" id="fpViewModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Product Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="card mb-3 shadow-sm">
          <div class="card-header bg-primary text-white"><i class="bi bi-info-circle me-1"></i> Product Information</div>
          <div class="card-body">
            <div class="row g-2">
              <div class="col-md-6"><div><span class="text-muted">Product ID:</span> <span id="vd_fp_id"></span></div></div>
              <div class="col-md-6"><div><span class="text-muted">Created:</span> <span id="vd_created"></span></div></div>
              <div class="col-md-6"><div><span class="text-muted">Raw Material ID:</span> <span id="vd_rmp_id"></span></div></div>
              <div class="col-md-6"><div><span class="text-muted">Polishing Job:</span> <span id="vd_pj_id"></span></div></div>
              <div class="col-md-6"><div><span class="text-muted">Material Type:</span> <span id="vd_type"></span></div></div>
              <div class="col-md-6"><div><span class="text-muted">Color:</span> <span id="vd_color"></span></div></div>
              <div class="col-md-6"><div><span class="text-muted">Finish:</span> <span id="vd_finish"></span></div></div>
              <div class="col-md-6"><div><span class="text-muted">Quality Grade:</span> <span id="vd_quality" class="badge bg-secondary"></span></div></div>
              <div class="col-md-6"><div><span class="text-muted">Stock Status:</span> <span id="vd_status" class="badge bg-secondary text-capitalize"></span></div></div>
              <div class="col-md-6"><div><span class="text-muted">Branch / Store:</span> <span id="vd_branch_store"></span></div></div>
            </div>
          </div>
        </div>

        <div class="card mb-3 shadow-sm">
          <div class="card-header bg-success text-white"><i class="bi bi-rulers me-1"></i> Dimensions & Timeline</div>
          <div class="card-body">
            <div class="row g-3">
              <div class="col-md-6">
                <div class="fw-semibold mb-2">Before Polishing</div>
                <div>Slab No: <span id="vd_slab"></span></div>
                <div>Raw Size: <span id="vd_raw_h"></span> x <span id="vd_raw_l"></span></div>
                <div>Raw Sq.Ft: <span id="vd_raw_sqft"></span></div>
                <div>Raw Quality: <span id="vd_raw_quality"></span></div>
                <div>PO: <span id="vd_po"></span></div>
              </div>
              <div class="col-md-6">
                <div class="fw-semibold mb-2">Polishing</div>
                <div>Worker: <span id="vd_worker"></span></div>
                <div>Start: <span id="vd_start"></span></div>
                <div>End: <span id="vd_end"></span></div>
                <div>Pre Size: <span id="vd_pre_h"></span> x <span id="vd_pre_l"></span></div>
                <div>Completed: <span id="vd_completed"></span></div>
              </div>
            </div>
          </div>
        </div>

        <div class="card mb-3 shadow-sm">
          <div class="card-header bg-info text-white"><i class="bi bi-truck me-1"></i> Purchase Order</div>
          <div class="card-body">
            <div class="row g-2">
              <div class="col-md-4">Order No: <span id="vd_po_no"></span></div>
              <div class="col-md-4">Order Date: <span id="vd_po_date"></span></div>
              <div class="col-md-4">Supplier: <span id="vd_supplier"></span></div>
              <div class="col-md-4">Ship Mode: <span id="vd_ship"></span></div>
              <div class="col-md-4">Delivery Term: <span id="vd_delivery"></span></div>
              <div class="col-md-4">Payment Term: <span id="vd_payment"></span></div>
            </div>
          </div>
        </div>

        <div class="card mb-2 shadow-sm">
          <div class="card-header bg-dark text-white"><i class="bi bi-box-seam me-1"></i> Final Product</div>
          <div class="card-body">
            <div class="row g-2">
              <div class="col-md-3">H: <span id="vd_final_h"></span></div>
              <div class="col-md-3">L: <span id="vd_final_l"></span></div>
              <div class="col-md-3">Sq.Ft: <span id="vd_final_sqft"></span></div>
              <div class="col-md-3">Finish: <span id="vd_final_finish"></span></div>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
  </div>

<script>
(function(){
  if (!$('.page-finished-products').length) return;
  // Role flag from server: only admins can edit/delete
  const CAN_EDIT_FP = <?php echo has_role(['admin','super_admin']) ? 'true' : 'false'; ?>;
  // Cache for stores to filter by branch in edit modal
  let FP_STORES = [];
  function buildStoreOptions(stores){
    const sopts=['<option value="">Select</option>'];
    (stores||[]).forEach(x=> sopts.push(`<option value="${x.id}">${$('<div>').text(x.name).html()}</option>`));
    return sopts.join('');
  }
  function refreshEditStores(branchId, selectedStoreId){
    const bid = parseInt(branchId||0,10);
    const list = isNaN(bid) || !bid ? [] : (FP_STORES||[]).filter(s=> parseInt(s.branch_id||0,10)===bid);
    $('#fp_store').html(buildStoreOptions(list));
    if (selectedStoreId) {
      $('#fp_store').val(String(selectedStoreId));
    } else if (list.length) {
      $('#fp_store').val(String(list[0].id));
    }
  }
  // (deduped) cached lookups removed
  function loadOptions(){
    $.get('api/finished_products.php', { action:'options' }, function(res){
      const topts=['<option value="">All</option>']; (res.types||[]).forEach(x=>topts.push(`<option value="${x.id}">${$('<div>').text(x.name).html()}</option>`));
      const copts=['<option value="">All</option>']; (res.colors||[]).forEach(x=>copts.push(`<option value="${x.id}">${$('<div>').text(x.name).html()}</option>`));
      const bopts=['<option value="">All</option>']; (res.branches||[]).forEach(x=>bopts.push(`<option value="${x.id}">${$('<div>').text(x.name).html()}</option>`));
      const sopts=['<option value="">All</option>']; (res.stores||[]).forEach(x=>sopts.push(`<option value="${x.id}">${$('<div>').text(x.name).html()}</option>`));
      FP_STORES = res.stores || [];
      $('#fltType').html(topts.join('')); $('#fltColor').html(copts.join('')); $('#fltBranch').html(bopts.join('')); $('#fltStore').html(sopts.join(''));
      // edit selects (branch normal, store will be filtered on branch selection)
      $('#fp_type').html(topts.join('').replace('All','Select'));
      $('#fp_color').html(copts.join('').replace('All','Select'));
      $('#fp_branch').html(bopts.join('').replace('All','Select'));
      $('#fp_store').html('<option value="">Select</option>');
    }).fail(function(xhr){ alert((xhr.responseJSON && xhr.responseJSON.message) || xhr.responseText || 'Error loading options'); });
    // finishes from existing materials API
    $.get('api/materials.php', { action:'list_finishes' }, function(res){
      const fopts=['<option value="">Select</option>']; (res.data||[]).forEach(f=>fopts.push(`<option value="${f.id}">${$('<div>').text(f.name).html()}</option>`)); $('#fp_finish').html(fopts.join(''));
    }).fail(function(xhr){ alert((xhr.responseJSON && xhr.responseJSON.message) || xhr.responseText || 'Error loading finishes'); });
  }

  function query(){
    const params={ action:'list',
      min_h: $('#fltMinH').val(), max_h: $('#fltMaxH').val(),
      min_l: $('#fltMinL').val(), max_l: $('#fltMaxL').val(),
      min_sqf: $('#fltMinSqf').val(), max_sqf: $('#fltMaxSqf').val(),
      type_id: $('#fltType').val(), color_id: $('#fltColor').val(),
      branch_id: $('#fltBranch').val(), store_location_id: $('#fltStore').val()
    };
    $.get('api/finished_products.php', params, function(res){
      const $tb=$('#fpList tbody'); $tb.empty(); const rows=res.data||[];
      if(!rows.length){ $tb.append('<tr><td colspan="15" class="text-center text-muted">No items</td></tr>'); return; }
      rows.forEach(r=>{
        const tr=$('<tr>');
        tr.append(`<td>${$('<div>').text(r.slab_no||'').html()}</td>`);
        tr.append(`<td>${$('<div>').text(r.finish_name||'').html()}</td>`);
        tr.append(`<td>${r.pre_height??''}</td>`);
        tr.append(`<td>${r.pre_length??''}</td>`);
        tr.append(`<td>${r.pre_sq_ft??''}</td>`);
        tr.append(`<td>${r.final_height??''}</td>`);
        tr.append(`<td>${r.final_length??''}</td>`);
        tr.append(`<td>${r.final_sq_ft??''}</td>`);
        tr.append(`<td>${$('<div>').text(r.type_name||'').html()}</td>`);
        tr.append(`<td>${$('<div>').text(r.color_name||'').html()}</td>`);
        tr.append(`<td>${$('<div>').text(r.branch_name||'').html()}</td>`);
        tr.append(`<td>${$('<div>').text(r.store_name||'').html()}</td>`);
        const comp = r.completed_at ? new Date(r.completed_at.replace(' ','T')).toLocaleString() : '';
        tr.append(`<td>${$('<div>').text(comp).html()}</td>`);
        tr.append(`<td><span class="badge bg-secondary text-capitalize">${r.sale_status||''}</span></td>`);
        const act = [];
        act.push(`<button class=\"btn btn-sm btn-outline-secondary me-1 btn-fp-view\" data-id=\"${r.id}\" title=\"View\" aria-label=\"View\"><i class=\"bi bi-eye\"></i></button>`);
        if (CAN_EDIT_FP) {
          act.push(`<button class=\"btn btn-sm btn-outline-primary me-1 btn-fp-edit\" data-id=\"${r.id}\" title=\"Edit\" aria-label=\"Edit\"><i class=\"bi bi-pencil\"></i></button>`);
          act.push(`<button class=\"btn btn-sm btn-outline-danger btn-fp-delete\" data-id=\"${r.id}\" title=\"Delete\" aria-label=\"Delete\"><i class=\"bi bi-trash\"></i></button>`);
        }
        tr.append(`<td>${act.join('')}</td>`);
        $tb.append(tr);
      });
    }).fail(function(xhr){ alert((xhr.responseJSON && xhr.responseJSON.message) || xhr.responseText || 'Error loading finished products'); });
  }

  // View details
  $(document).on('click','.btn-fp-view', function(){
    const id=$(this).data('id');
    $.get('api/finished_products.php', { action:'detail', id }, function(resp){
      const d=resp.data||{};
      const fmtDT = v=> v? new Date(String(v).replace(' ','T')).toLocaleString():'';
      $('#vd_fp_id').text(d.id||'');
      $('#vd_created').text(fmtDT(d.created_at||d.ready_at));
      $('#vd_rmp_id').text(d.rmp_internal_id||d.rmp_id||'');
      $('#vd_pj_id').text(d.polishing_job_id||'');
      $('#vd_type').text(d.type_name||'');
      $('#vd_color').text(d.color_name||'');
      $('#vd_finish').text(d.finish_name||'');
      $('#vd_quality').text(d.quality||d.raw_quality||'');
      $('#vd_status').text(d.sale_status||'');
      $('#vd_branch_store').text([d.branch_name||'', d.store_name||''].filter(Boolean).join(' / '));

      $('#vd_slab').text(d.slab_no||'');
      $('#vd_raw_h').text(d.raw_height??'');
      $('#vd_raw_l').text(d.raw_length??'');
      $('#vd_raw_sqft').text(d.raw_sq_ft??'');
      $('#vd_raw_quality').text(d.raw_quality||'');
      $('#vd_po').text(d.order_no||'');
      // PO section
      $('#vd_po_no').text(d.order_no||'');
      $('#vd_po_date').text(d.order_date||'');
      $('#vd_supplier').text(d.supplier_name||'');
      $('#vd_ship').text(d.ship_mode||'');
      $('#vd_delivery').text(d.delivery_term||'');
      $('#vd_payment').text(d.payment_term||'');

      $('#vd_worker').text(d.worker_name||'');
      $('#vd_start').text(fmtDT(d.start_at));
      $('#vd_end').text(fmtDT(d.end_at));
      $('#vd_pre_h').text(d.pre_height??'');
      $('#vd_pre_l').text(d.pre_length??'');
      $('#vd_completed').text(fmtDT(d.completed_at));

      $('#vd_final_h').text(d.final_height??'');
      $('#vd_final_l').text(d.final_length??'');
      $('#vd_final_sqft').text(d.final_sq_ft??'');
      $('#vd_final_finish').text(d.finish_name||'');

      $('#fpViewModal').modal('show');
    }).fail(xhr=>alert((xhr.responseJSON&&xhr.responseJSON.message)||xhr.responseText||'Error loading details'));
  });

  // open edit
  $(document).on('click','.btn-fp-edit', function(){
    const id=$(this).data('id');
    $.get('api/finished_products.php', { action:'get', id }, function(res){
      const d=res.data||{};
      $('#fp_id').val(d.id); $('#fp_h').val(d.final_height||''); $('#fp_l').val(d.final_length||''); $('#fp_sqf').val(d.final_sq_ft||'');
      $('#fp_finish').val(d.finish_id||''); $('#fp_type').val(d.type_id||''); $('#fp_color').val(d.color_id||'');
      $('#fp_branch').val(d.branch_id||'');
      refreshEditStores(d.branch_id, d.store_location_id);
      $('#fp_quality').val(d.quality||''); $('#fp_status').val(d.sale_status||'available');
      $('#fpEditModal').modal('show');
    });
  });

  // when branch changes in edit modal, auto-filter stores and select first store of that branch
  $(document).on('change', '#fp_branch', function(){
    const bid = this.value;
    refreshEditStores(bid, null);
  });

  // (duplicate refreshEditStores removed)
  // save edit
  // Save edit (only if allowed)
  $('#fpEditForm').on('submit', function(e){ e.preventDefault(); if(!CAN_EDIT_FP){ return; } const fd=new FormData(this); fd.append('action','update');
    $.ajax({ url:'api/finished_products.php', method:'POST', data:fd, contentType:false, processData:false })
      .done(function(){ $('#fpEditModal').modal('hide'); query(); })
      .fail(function(xhr){ alert((xhr.responseJSON && xhr.responseJSON.message) || 'Error'); });
  });

  // delete
  $(document).on('click','.btn-fp-delete', function(){ if(!CAN_EDIT_FP){ return; } if(!confirm('Delete this item?')) return; const id=$(this).data('id');
    const fd=new FormData(); fd.append('csrf','<?php echo htmlspecialchars(csrf_token()); ?>'); fd.append('action','delete'); fd.append('id', id);
    $.ajax({ url:'api/finished_products.php', method:'POST', data:fd, contentType:false, processData:false })
      .done(function(){ query(); })
      .fail(function(xhr){ alert((xhr.responseJSON && xhr.responseJSON.message) || 'Error'); });
  });

  $('#btnSearch').on('click', query);
  loadOptions(); query();
})();
</script>
