<?php require_once __DIR__ . '/../includes/auth.php'; require_login(); require_once __DIR__ . '/../includes/db.php'; require_once __DIR__ . '/../config.php';
$mysqli = db();
$id = (int)($_GET['id'] ?? 0);
if (!$id) { echo 'Missing id'; exit; }
$inv = $mysqli->query('SELECT i.*, c.name AS customer_name, c.address, c.phone, c.email, c.gst_no FROM invoices i JOIN customers c ON c.id=i.customer_id WHERE i.id='.(int)$id)->fetch_assoc();
$settings = $mysqli->query('SELECT company_name, address_line, city_country, company_email, phone FROM shop_settings LIMIT 1')->fetch_assoc();
if (!$inv) { echo 'Invoice not found'; exit; }
$items = [];$res=$mysqli->query('SELECT description, qty, unit_price, line_total FROM invoice_items WHERE invoice_id='.(int)$id);
while($r=$res->fetch_assoc()){ $items[]=$r; }
$payments = [];$sumPaid = 0.0; $res2=$mysqli->query('SELECT pay_date, method, reference_no, amount FROM payments WHERE invoice_id='.(int)$id.' ORDER BY id');
while($r2=$res2->fetch_assoc()){ $payments[]=$r2; $sumPaid += (float)$r2['amount']; }
$balance = max(0, (float)$inv['grand_total'] - $sumPaid);
?><!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>Invoice <?php echo htmlspecialchars($inv['invoice_no']); ?></title>
<style>
  @page { size: A4; margin: 18mm; }
  body { font-family: Arial, sans-serif; color:#222; margin:0; }
  /* Repeat this header on each printed page */
  .print-header { display: table-header-group; }
  .header { width:210mm;display:flex; justify-content:space-between; align-items:flex-start; margin-bottom: 10px; }
  .header .right { margin-left:auto; text-align:right; }
  .company { font-size: 18px; font-weight: 700; }
  .muted { color:#6c757d; }
  table { width:100%; border-collapse: collapse; }
  th, td { padding: 8px; border-bottom: 1px solid #e5e5e5; }
  th { background:#f8f9fa; text-align:left; }
  .totals { width: 360px; margin-left:auto; }
  .text-end { text-align:right; }
  .text-center { text-align:center; }
  .small { font-size: 12px; }
  .mb-2 { margin-bottom: 8px; }
  .mb-3 { margin-bottom: 12px; }
  .mt-2 { margin-top: 8px; }
  .badge { display:inline-block; padding:2px 6px; background:#e9ecef; border-radius:4px; font-size:12px; }
  .footer { margin-top: 28px; font-size: 12px; color:#6c757d; }
  .title { font-size: 24px; font-weight:700; }
  .sig { margin-top: 80px; display:flex; justify-content:flex-end; }
  .sig .line { width: 320px; border-top: 1px solid #000; text-align:center; padding-top:8px; font-size: 12px; }
</style>
</head>
<body>
  <div class="print-header">
    <div class="text-center title">INVOICE</div>
    <div class="header">
      <div>
        <div class="small">Invoice No: <strong><?php echo htmlspecialchars($inv['invoice_no']); ?></strong></div>
        <div class="small">Date: <?php echo htmlspecialchars($inv['invoice_date']); ?></div>
        <div class="small">Status: <span class="badge"><?php echo htmlspecialchars($inv['status']); ?></span></div>
      </div>
      <div class="right">
        <div class="company"><?php echo htmlspecialchars($settings['company_name'] ?? 'Your Company Name'); ?></div>
        <div class="small"><?php echo nl2br(htmlspecialchars(trim($settings['address_line'] ?? '')."\n".($settings['city_country'] ?? ''))); ?></div>
        <div class="small"><?php echo htmlspecialchars($settings['phone'] ?? ''); ?> <?php echo htmlspecialchars($settings['company_email'] ?? ''); ?></div>
        <div class="small"><?php echo htmlspecialchars($settings['company_email'] ?? ''); ?></div>
      </div>
    </div>
    <div class="mb-2" style="display:flex; gap:40px;">
      <div style="flex:1;">
        <div><strong><?php echo htmlspecialchars($inv['customer_name']); ?></strong></div>
        <div class="small"><?php echo nl2br(htmlspecialchars($inv['address'] ?? '')); ?></div>
        <div class="small"><?php echo htmlspecialchars($inv['phone'] ?? ''); ?> <?php echo htmlspecialchars($inv['email'] ?? ''); ?></div>
      </div>
    </div>
  </div>

  <table>
    <thead><tr><th>#</th><th>Description</th><th class="text-end">Qty</th><th class="text-end">Unit (LKR)</th><th class="text-end">Line (LKR)</th></tr></thead>
    <tbody>
      <?php $i=1; 
      foreach ($items as $it): ?>
      <tr>
        <td><?php echo htmlspecialchars($i); ?></td>
        <td><?php echo htmlspecialchars($it['description']); ?></td>
        <td class="text-end"><?php echo htmlspecialchars($it['qty']); ?></td>
        <td class="text-end"><?php echo number_format((float)$it['unit_price'], 2); ?></td>
        <td class="text-end"><?php echo number_format((float)$it['line_total'], 2); ?></td>
      </tr>
      <?php 
    $i++;
    endforeach; ?>
    </tbody>
  </table>

  <table class="totals mt-2">
    <tr><td>Subtotal</td><td class="text-end">LKR <?php echo number_format((float)$inv['subtotal'], 2); ?></td></tr>
    <tr><td>Tax (<?php echo number_format((float)$inv['tax_percent'],2); ?>%)</td><td class="text-end">LKR <?php echo number_format((float)$inv['tax_amount'], 2); ?></td></tr>
    <tr><td>Transport</td><td class="text-end">LKR <?php echo number_format((float)$inv['transport_charges'], 2); ?></td></tr>
    <tr><td>Discount</td><td class="text-end">LKR <?php echo number_format((float)$inv['discount'], 2); ?></td></tr>
    <tr><th>Total</th><th class="text-end">LKR <?php echo number_format((float)$inv['grand_total'], 2); ?></th></tr>
    <tr><td>Paid</td><td class="text-end">LKR <?php echo number_format((float)$sumPaid, 2); ?></td></tr>
    <tr><th>Balance</th><th class="text-end">LKR <?php echo number_format((float)$balance, 2); ?></th></tr>
  </table>

  
  <div class="sig">
    <div class="line">Authorized Signature</div>
  </div>

  <div class="footer">
    Thank you for your business.
  </div>

  <script>window.print();</script>
</body>
</html>
