<?php require_once __DIR__ . '/../includes/auth.php'; require_login(); require_once __DIR__ . '/../includes/db.php'; ?>
<div class="page-materials">
<div class="container-fluid p-4">
  <ul class="nav nav-tabs mb-3" id="materialsTabs" role="tablist">
    <li class="nav-item" role="presentation">
      <button class="nav-link active" id="tab-master-btn" data-bs-toggle="tab" data-bs-target="#tab-master" type="button" role="tab">Master Materials</button>
    </li>
  </ul>

  <div class="tab-content">
  <div class="tab-pane fade show active" id="tab-master" role="tabpanel">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4>Materials</h4>
    <button id="btnAddMaterial" class="btn btn-primary">Add Material</button>
  </div>
  <div class="card shadow-sm">
    <div class="card-body">
      <div class="table-responsive">
        <table id="materials-table" class="table table-hover align-middle">
          <thead>
            <tr>
              <th>ID</th>
              <th>Code</th>
              <th>Name</th>
              <th>Type</th>
              <th>Finish</th>
              <th>Color</th>
              <th>L (mm)</th>
              <th>W (mm)</th>
              <th>T (mm)</th>
              <th>Status</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
  </div>
  </div>
</div>

<input type="hidden" id="csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>" />

<div class="modal fade" id="materialModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Material</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form id="materialForm">
        <div class="modal-body">
          <input type="hidden" name="csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
          <input type="hidden" id="materialId" name="id">
          <div class="row g-3">
            <div class="col-md-6">
              <div class="mb-2">
                <label class="form-label">Material Code</label>
                <div class="input-group">
                  <input type="text" class="form-control" id="material_code" name="material_code" placeholder="Auto-generate if left blank">
                  <button class="btn btn-outline-secondary" type="button" id="btnGenMaterialCode">Generate</button>
                </div>
              </div>
              <div class="mb-2">
                <label class="form-label">Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="m_name" name="name" required>
              </div>
              <div class="mb-2">
                <label class="form-label">Type</label>
                <div class="input-group">
                  <select class="form-select" id="type_id" name="type_id"></select>
                  <button class="btn btn-outline-primary" type="button" id="btnAddType">Add</button>
                </div>
              </div>
              <div class="mb-2">
                <label class="form-label">Finish</label>
                <div class="input-group">
                  <select class="form-select" id="finish_id" name="finish_id"></select>
                  <button class="btn btn-outline-primary" type="button" id="btnAddFinish">Add</button>
                </div>
              </div>
              <div class="mb-2">
                <label class="form-label">Color</label>
                <div class="input-group">
                  <select class="form-select" id="color_id" name="color_id"></select>
                  <button class="btn btn-outline-primary" type="button" id="btnAddColor">Add</button>
                </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="row g-2">
                <div class="col-md-4">
                  <label class="form-label">Length (mm)</label>
                  <input type="number" step="0.01" class="form-control" id="length_mm" name="length_mm">
                </div>
                <div class="col-md-4">
                  <label class="form-label">Width (mm)</label>
                  <input type="number" step="0.01" class="form-control" id="width_mm" name="width_mm">
                </div>
                <div class="col-md-4">
                  <label class="form-label">Thickness (mm)</label>
                  <input type="number" step="0.01" class="form-control" id="thickness_mm" name="thickness_mm">
                </div>
              </div>
              <div class="mb-2">
                <label class="form-label">Notes</label>
                <textarea class="form-control" id="m_notes" name="notes" rows="3"></textarea>
              </div>
              <div class="form-check form-switch mt-2">
                <input class="form-check-input" type="checkbox" id="m_is_active" name="is_active" checked>
                <label class="form-check-label" for="m_is_active">Active</label>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary">Save</button>
        </div>
      </form>
    </div>
  </div>
</div>
</div>
