<?php require_once __DIR__ . '/../includes/auth.php'; require_login(); ?>
<div class="page-slab_cutting">
  <div class="container-fluid p-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
      <h4>Slab Cutting</h4>
    </div>

    <div class="row g-3">
      <div class="col-lg-5">
        <div class="card shadow-sm mb-3">
          <div class="card-header">Create Cutting Job</div>
          <div class="card-body">
            <form id="cutJobForm">
              <input type="hidden" name="csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
              <div class="mb-2">
                <label class="form-label">Source Type</label>
                <select class="form-select" id="source_type" name="source_type">
                  <option value="raw">Raw Material (RMP)</option>
                  <option value="finished">Finished Product (FP)</option>
                  <option value="cut_piece">Cut Piece (Re-cut)</option>
                </select>
              </div>
              <div class="mb-2">
                <label class="form-label">Source</label>
                <div class="input-group mb-1">
                  <input type="text" class="form-control" id="source_search" placeholder="Search by slab no / code">
                  <button class="btn btn-outline-secondary" type="button" id="btnRefreshSources"><i class="bi bi-arrow-clockwise"></i></button>
                </div>
                <select class="form-select" id="source_id" name="source_id"></select>
                <div class="form-text">Pick slab to cut (from RM or Finished)</div>
              </div>
              <div class="mb-2 d-flex justify-content-between align-items-center">
                <label class="form-label mb-0">Pieces</label>
                <div class="d-flex gap-2">
                  <button type="button" id="btnAddPiece" class="btn btn-sm btn-outline-primary"><i class="bi bi-plus-circle"></i> Add Piece</button>
                  <button type="button" id="btnClearPieces" class="btn btn-sm btn-outline-secondary">Clear</button>
                </div>
              </div>
              <div class="table-responsive border rounded">
                <table class="table table-sm align-middle mb-0" id="piecesTable">
                  <thead><tr><th style="width:70px">#</th><th>Length (mm)</th><th>Width (mm)</th><th style="width:140px" class="text-end">Area (sqft)</th><th style="width:60px"></th></tr></thead>
                  <tbody></tbody>
                </table>
              </div>
              <div class="text-end small text-muted mt-1">Total Area: <span id="piecesTotal">0.000</span> sqft</div>
              <div class="mt-3">
                <label class="form-label">Operator</label>
                <input type="text" class="form-control" id="operator_name" name="operator_name" placeholder="Operator name">
              </div>
              <div class="mt-2">
                <label class="form-label">Notes</label>
                <input type="text" class="form-control" id="notes" name="notes">
              </div>
              <div class="mt-3 d-flex gap-2">
                <button type="submit" class="btn btn-primary">Create Job</button>
                <button type="button" class="btn btn-outline-secondary" id="btnClearCutForm">Clear</button>
              </div>
            </form>
          </div>
        </div>
      </div>

      <div class="col-lg-7">
        <div class="card shadow-sm mb-3">
          <div class="card-header d-flex justify-content-between align-items-center">
            <span>Cut Pieces Inventory</span>
            <div class="d-flex gap-2">
              <button class="btn btn-sm btn-outline-secondary" id="btnRefreshPieces"><i class="bi bi-arrow-clockwise"></i></button>
            </div>
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table id="cut-pieces-table" class="table table-hover align-middle">
                <thead>
                  <tr>
                    <th>ID</th>
                    <th>Job</th>
                    <th>Piece</th>
                    <th>Size (mm)</th>
                    <th>Area (sqft)</th>
                    <th>Available</th>
                  </tr>
                </thead>
                <tbody></tbody>
              </table>
            </div>
          </div>
        </div>

        <div class="card shadow-sm">
          <div class="card-header">Recent Cutting Jobs</div>
          <div class="card-body">
            <div class="table-responsive">
              <table id="cut-jobs-table" class="table table-sm table-striped">
                <thead>
                  <tr>
                    <th>ID</th>
                    <th>Date</th>
                    <th>Source</th>
                    <th>Operator</th>
                    <th>Status</th>
                    <th>Actions</th>
                  </tr>
                </thead>
                <tbody></tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>

    <input type="hidden" id="csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>" />
  </div>
</div>
