<?php
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/includes/auth.php';
require_once __DIR__ . '/includes/db.php';
require_login();

$mysqli = db();
$id = (int)($_GET['id'] ?? 0);
if (!$id) { echo 'Missing id'; exit; }

// Load payroll row
$stmt = $mysqli->prepare('SELECT p.*, e.full_name, e.emp_code FROM salary_payroll p LEFT JOIN employees e ON e.id=p.employee_id WHERE p.id=?');
$stmt->bind_param('i',$id); $stmt->execute(); $pay = $stmt->get_result()->fetch_assoc();
if (!$pay) { echo 'Not found'; exit; }

// Load period bounds for breakdown
$month = (int)$pay['period_month']; $year = (int)$pay['period_year'];
$first = sprintf('%04d-%02d-01',$year,$month);
$last = date('Y-m-t', strtotime($first));

// Sums used (already stored but also show detailed lists if desired later)
$gross = (float)$pay['gross_salary'];
$adv = (float)$pay['total_advances'];
$ded = (float)$pay['total_deductions'];
$net = (float)$pay['net_salary'];

// Allowances for the period (informational; net/gross may already account for these in payroll calc)
$allowances = [];
$allow_total = 0.0;
if (!empty($pay['employee_id'])) {
  $eid = (int)$pay['employee_id'];
  $resAll = $mysqli->query("SELECT id, all_date, amount, reason FROM salary_allowances WHERE employee_id=".$eid." AND all_date BETWEEN '".$mysqli->real_escape_string($first)."' AND '".$mysqli->real_escape_string($last)."' ORDER BY all_date ASC, id ASC");
  if ($resAll) {
    while($r=$resAll->fetch_assoc()){ $allowances[]=$r; $allow_total += (float)$r['amount']; }
  }
}

// Incentives for the period
$incentives = [];
$inc_total = 0.0;
if (!empty($pay['employee_id'])) {
  $eid = (int)$pay['employee_id'];
  $resInc = $mysqli->query("SELECT id, inc_date, amount, reason FROM salary_incentives WHERE employee_id=".$eid." AND inc_date BETWEEN '".$mysqli->real_escape_string($first)."' AND '".$mysqli->real_escape_string($last)."' ORDER BY inc_date ASC, id ASC");
  if ($resInc) {
    while($r=$resInc->fetch_assoc()){ $incentives[]=$r; $inc_total += (float)$r['amount']; }
  }
}

// Shop settings
$settings = [ 'company_name'=>'Granite Warehouse','address_line'=>'Warehouse Address Line','city_country'=>'City, Country','company_email'=>'','phone'=>'-' ];
$resSet = $mysqli->query('SELECT company_name, address_line, city_country, company_email, phone FROM shop_settings ORDER BY id ASC LIMIT 1');
if ($resSet && $rowS = $resSet->fetch_assoc()) { $settings = array_merge($settings, $rowS); }
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Salary Slip - <?php echo htmlspecialchars($pay['full_name']); ?> (<?php echo date('M Y', strtotime($first)); ?>)</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background:#fff; }
    .slip { max-width: 800px; margin: 20px auto; border:1px solid #dee2e6; padding:20px; }
    .header { border-bottom:1px solid #dee2e6; padding-bottom:10px; margin-bottom:15px; }
    .company { font-weight:600; font-size:18px; }
    .meta label { width: 140px; display:inline-block; color:#6c757d; }
    .table-sm th, .table-sm td { padding: .35rem .5rem; }
    @media print { .no-print { display:none !important; } }
  </style>
</head>
<body>
  <div class="slip">
    <div class="d-flex justify-content-between align-items-start header">
      <div>
        <div class="company"><?php echo htmlspecialchars($settings['company_name']); ?></div>
        <div><?php echo htmlspecialchars($settings['address_line']); ?></div>
        <div><?php echo htmlspecialchars($settings['city_country']); ?></div>
        <div>Email: <?php echo htmlspecialchars($settings['company_email']); ?> | Phone: <?php echo htmlspecialchars($settings['phone']); ?></div>
      </div>
      <div class="text-end">
        <button class="btn btn-primary no-print" onclick="window.print()">Print</button>
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-7 meta">
        <div><label>Employee:</label> <strong><?php echo htmlspecialchars($pay['full_name']); ?></strong> (<?php echo htmlspecialchars($pay['emp_code'] ?? ''); ?>)</div>
        <div><label>Period:</label> <?php echo date('F Y', strtotime($first)); ?></div>
        <div><label>Generated On:</label> <?php echo htmlspecialchars(date('Y-m-d', strtotime($pay['created_at'] ?? date('Y-m-d')))); ?></div>
      </div>
      <div class="col-md-5">
        <table class="table table-sm">
          <tbody>
            <tr><th>Gross Salary</th><td class="text-end"><?php echo number_format($gross,2); ?></td></tr>
            <tr><th>Total Allowances</th><td class="text-end"><?php echo number_format($allow_total,2); ?></td></tr>
            <tr><th>Total Incentives</th><td class="text-end"><?php echo number_format($inc_total,2); ?></td></tr>
            <tr><th>Total Advances</th><td class="text-end"><?php echo number_format($adv,2); ?></td></tr>
            <tr><th>Total Deductions</th><td class="text-end"><?php echo number_format($ded,2); ?></td></tr>
            <tr class="table-light"><th>Net Salary</th><td class="text-end"><strong><?php echo number_format($net,2); ?></strong></td></tr>
          </tbody>
        </table>
      </div>
    </div>

    <?php if ($allowances): ?>
    <div class="mb-3">
      <h6>Allowances (<?php echo date('Y-m-d', strtotime($first)); ?> to <?php echo date('Y-m-d', strtotime($last)); ?>)</h6>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th style="width:120px;">Date</th><th>Reason</th><th class="text-end" style="width:160px;">Amount</th></tr></thead>
          <tbody>
            <?php foreach ($allowances as $a): ?>
            <tr>
              <td><?php echo htmlspecialchars($a['all_date']); ?></td>
              <td><?php echo htmlspecialchars($a['reason'] ?? ''); ?></td>
              <td class="text-end"><?php echo number_format((float)$a['amount'],2); ?></td>
            </tr>
            <?php endforeach; ?>
            <tr class="table-light">
              <th colspan="2" class="text-end">Total</th>
              <th class="text-end"><?php echo number_format($allow_total,2); ?></th>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
    <?php endif; ?>

    <?php if ($incentives): ?>
    <div class="mb-3">
      <h6>Incentives (<?php echo date('Y-m-d', strtotime($first)); ?> to <?php echo date('Y-m-d', strtotime($last)); ?>)</h6>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th style="width:120px;">Date</th><th>Reason</th><th class="text-end" style="width:160px;">Amount</th></tr></thead>
          <tbody>
            <?php foreach ($incentives as $a): ?>
            <tr>
              <td><?php echo htmlspecialchars($a['inc_date']); ?></td>
              <td><?php echo htmlspecialchars($a['reason'] ?? ''); ?></td>
              <td class="text-end"><?php echo number_format((float)$a['amount'],2); ?></td>
            </tr>
            <?php endforeach; ?>
            <tr class="table-light">
              <th colspan="2" class="text-end">Total</th>
              <th class="text-end"><?php echo number_format($inc_total,2); ?></th>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
    <?php endif; ?>

    <div class="row mt-4">
      <div class="col-6 text-center" style="padding-top:40px; border-top:1px solid #dee2e6; margin-top:40px;">Employee Signature</div>
      <div class="col-6 text-center" style="padding-top:40px; border-top:1px solid #dee2e6; margin-top:40px;">Authorized Signature</div>
    </div>
  </div>
</body>
</html>
